/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.newtypes;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import mcp.mobius.opis.data.holders.ISerializable;

public class DataByteRate
implements Comparable<DataByteRate>,
ISerializable {
    public Long size;
    public int interval;

    public DataByteRate(long size, int interval) {
        this.size = size;
        this.interval = interval;
    }

    @Override
    public int compareTo(DataByteRate o) {
        return o.size.compareTo(this.size);
    }

    public void reset() {
        this.size = 0L;
    }

    public String toString() {
        if (this.size >= 1024L && this.size < 0x100000L) {
            return String.format("%.3f KiB/s", (double)this.size.longValue() / 1024.0 / (double)this.interval);
        }
        if (this.size >= 0x100000L) {
            return String.format("%.3f MiB/s", (double)this.size.longValue() / 1024.0 / 1024.0 / (double)this.interval);
        }
        return String.format("%4d   B/s", this.size / (long)this.interval);
    }

    @Override
    public void writeToStream(ByteArrayDataOutput stream) {
        stream.writeLong(this.size.longValue());
        stream.writeInt(this.interval);
    }

    public static DataByteRate readFromStream(ByteArrayDataInput stream) {
        return new DataByteRate(stream.readLong(), stream.readInt());
    }
}

