/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client.dynamicgui.elements;

import eu.usrv.yamcore.client.dynamicgui.elements.IGuiElement;
import eu.usrv.yamcore.client.dynamicgui.widgets.IWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

public class InfoPanelControlerEl
implements IWidget {
    private static final int framesToOpen = 15;
    final FontRenderer font;
    final IGuiElement child;
    public String descriptionText;
    private boolean open;
    private boolean moving;
    private int x;
    private int y;
    private int width;
    private int height;
    private int widthLow;
    private int heightLow;
    private float progress = 0.0f;

    public InfoPanelControlerEl(FontRenderer font, IGuiElement child, int widthLow, int heightLow, int widthHigh, int heightHigh, String description, int x, int y) {
        this.width = widthHigh;
        this.height = heightHigh;
        this.widthLow = widthLow;
        this.heightLow = heightLow;
        this.descriptionText = description;
        this.font = font;
        this.x = x;
        this.y = y;
        this.child = child;
    }

    public void doOpen() {
        this.open = false;
        this.moving = true;
    }

    public void doClose() {
        this.open = true;
        this.moving = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public int getMovedY() {
        return (int)(this.progress * (float)(this.height - this.heightLow));
    }

    @Override
    public void update() {
        if (this.moving && !this.open) {
            float f;
            this.progress += 0.06666667f;
            if (f > 1.0f) {
                this.progress = 1.0f;
                this.open = true;
                this.moving = false;
            }
        }
        if (this.moving && this.open) {
            float f;
            this.progress -= 0.06666667f;
            if (f < 0.0f) {
                this.progress = 0.0f;
                this.open = false;
                this.moving = false;
            }
        }
    }

    @Override
    public void drawBackground(Minecraft mc, int mouseX, int mouseY) {
        GL11.glTranslatef((float)(this.x + this.getMovedX()), (float)(this.y + this.getMovedY()), (float)0.0f);
        this.child.drawBackground(mc, mouseX, mouseY);
        this.child.drawForeground(mc, mouseX, mouseY);
    }

    @Override
    public void drawForeground(Minecraft mc, int mouseX, int mouseY) {
    }

    public int getMovedX() {
        return (int)(this.progress * (float)(this.width - this.widthLow));
    }

    public boolean isClickInBounds(int clickX, int clickY) {
        return clickX > this.x && clickY > this.y && clickX < this.x + this.width + this.getMovedX() && clickY < this.y + this.height + this.getMovedY();
    }

    @Override
    public int getElementHeight() {
        return this.height;
    }

    @Override
    public int getElementWidth() {
        return this.width;
    }

    @Override
    public int getElementY() {
        return this.y;
    }

    @Override
    public int getElementX() {
        return this.x;
    }
}

