/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.math;

import com.cleanroommc.modularui.utils.Interpolations;

public enum Direction {
    TOP(0.5f, 0.0f),
    LEFT(0.0f, 0.5f),
    BOTTOM(0.5f, 1.0f),
    RIGHT(1.0f, 0.5f);

    public final float anchorX;
    public final float anchorY;
    public final int factorX;
    public final int factorY;

    private Direction(float anchorX, float anchorY) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.factorX = (int)Interpolations.lerp(-1.0f, 1.0f, anchorX);
        this.factorY = (int)Interpolations.lerp(-1.0f, 1.0f, anchorY);
    }

    public boolean isHorizontal() {
        return this == LEFT || this == RIGHT;
    }

    public boolean isVertical() {
        return this == TOP || this == BOTTOM;
    }

    public Direction opposite() {
        if (this == TOP) {
            return BOTTOM;
        }
        if (this == BOTTOM) {
            return TOP;
        }
        if (this == LEFT) {
            return RIGHT;
        }
        return LEFT;
    }
}

