/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.IOException;
import java.util.Map;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.prefab.ManagedEnvironment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.sound.Audio;
import pl.asie.computronics.util.sound.AudioType;
import pl.asie.computronics.util.sound.Channel;
import pl.asie.lib.network.Packet;

public abstract class DriverCardSoundBase
extends ManagedEnvironment
implements DeviceInfo {
    protected final EnvironmentHost host;
    protected final Long[] expirationList;
    protected final String playMethodName;
    protected Channel.FreqPair[] sendBuffer;
    protected Map<String, String> deviceInfo;

    public DriverCardSoundBase(EnvironmentHost host, String playMethodName) {
        this.host = host;
        this.expirationList = new Long[8];
        this.playMethodName = playMethodName;
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        long currentTime = this.host.world().func_82737_E();
        for (int i = 0; i < this.expirationList.length; ++i) {
            if (this.expirationList[i] == null || this.expirationList[i] > currentTime) continue;
            this.expirationList[i] = null;
        }
        if (this.sendBuffer != null) {
            try {
                this.sendSound(this.host.world(), this.host.xPosition(), this.host.yPosition(), this.host.zPosition(), this.sendBuffer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sendBuffer = null;
        }
    }

    protected int getActiveChannelCount() {
        return DriverCardSoundBase.getNonNullCount(this.expirationList);
    }

    protected static <E, T extends Iterable<E>> int getNonNullCount(T array) {
        int c = 0;
        for (E e : array) {
            if (e == null) continue;
            ++c;
        }
        return c;
    }

    protected static <E> int getNonNullCount(E[] array) {
        int c = 0;
        for (E e : array) {
            if (e == null) continue;
            ++c;
        }
        return c;
    }

    protected Object[] tryConsumeEnergy(double v, String methodName) {
        int power;
        if (this.node() instanceof Connector && (power = this.tryConsumeEnergy(v)) < 0) {
            return new Object[]{false, power + ": " + methodName + ": not enough energy available: required" + v + ", found " + ((Connector)this.node()).globalBuffer()};
        }
        return null;
    }

    protected Object[] tryQueueSound(Channel.FreqPair[] freqPairs, Object[] result, double v, String methodName) throws Exception {
        Object[] error = this.tryConsumeEnergy(v, methodName);
        if (error != null) {
            return error;
        }
        if (this.sendBuffer == null) {
            this.sendBuffer = freqPairs;
        } else {
            int size = Math.min(this.sendBuffer.length, freqPairs.length);
            for (int i = 0; i < size; ++i) {
                if (this.sendBuffer[i] != null) continue;
                this.sendBuffer[i] = freqPairs[i];
            }
        }
        return result;
    }

    protected void sendSound(World world, double x, double y, double z, Channel.FreqPair[] freqPairs) throws Exception {
        int size = Math.min(freqPairs.length, 8);
        byte hits = 0;
        for (int i = 0; i < size; ++i) {
            if (freqPairs[i] == null) continue;
            hits = (byte)(hits | 1 << i);
        }
        Packet packet = Computronics.packet.create(PacketType.COMPUTER_BEEP.ordinal()).writeInt(world.field_73011_w.field_76574_g).writeFloat((float)x).writeFloat((float)y).writeFloat((float)z).writeByte(hits);
        for (int i = 0; i < freqPairs.length; ++i) {
            Channel.FreqPair freqPair = freqPairs[i];
            if (freqPair == null) continue;
            packet.writeByte((byte)this.getMode(i).ordinal()).writeFloat(freqPair.frequency).writeShort((short)freqPair.duration);
        }
        Computronics.packet.sendToAllAround(packet, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, (double)Config.SOUND_RADIUS));
    }

    protected abstract AudioType getMode(int var1);

    public static void onSound(Packet packet, EntityPlayer player) throws IOException {
        int dimension = packet.readInt();
        if (DriverCardSoundBase.isInDimension(player, dimension)) {
            float x = packet.readFloat();
            float y = packet.readFloat();
            float z = packet.readFloat();
            int hits = packet.readUnsignedByte();
            for (int i = 0; i < 8; ++i) {
                if ((hits >> i & 1) != 1) continue;
                AudioType type = AudioType.fromIndex(packet.readUnsignedByte());
                float frequency = packet.readFloat();
                short duration = packet.readShort();
                Audio.instance().play(x, y, z, type, frequency, duration & 0xFFFF);
            }
        }
    }

    protected int tryConsumeEnergy(double v) {
        if (v < 0.0) {
            return -2;
        }
        v = -v;
        if (this.node() instanceof Connector) {
            Connector connector = (Connector)this.node();
            return connector.tryChangeBuffer(v) ? 1 : -1;
        }
        return 0;
    }

    protected static double optDouble(Number value, double def) {
        if (value == null) {
            return def;
        }
        return value.doubleValue();
    }

    protected static boolean isInDimension(EntityPlayer player, int dimension) {
        return player != null && player.field_70170_p != null && player.field_70170_p.field_73011_w != null && player.field_70170_p.field_73011_w.field_76574_g == dimension;
    }

    public Map<String, String> getDeviceInfo() {
        OCUtils.Device device;
        if (this.deviceInfo == null && (device = this.deviceInfo()) != null) {
            this.deviceInfo = device.deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }

    protected abstract OCUtils.Device deviceInfo();
}

