/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.savedata.types;

import chylex.hee.mechanics.energy.EnergyChunkData;
import chylex.hee.mechanics.energy.EnergyChunkDataOverworld;
import chylex.hee.system.logging.Log;
import chylex.hee.system.savedata.WorldSavefile;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class EnergySavefile
extends WorldSavefile {
    private static final EnergyChunkDataOverworld chunkDataOverworld = new EnergyChunkDataOverworld();
    public static byte sectionSize = (byte)4;
    private Map<ChunkCoordIntPair, EnergyChunkData> chunkMap = new HashMap<ChunkCoordIntPair, EnergyChunkData>();

    public EnergySavefile() {
        super("energy.nbt");
    }

    public EnergyChunkData getFromChunkCoords(World world, int chunkX, int chunkZ, boolean setModified) {
        ChunkCoordIntPair coords;
        EnergyChunkData data;
        if (world.field_73011_w.field_76574_g != 1) {
            return chunkDataOverworld;
        }
        if (setModified) {
            this.setModified();
        }
        if (chunkX < 0) {
            chunkX -= sectionSize - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= sectionSize - 1;
        }
        if ((data = this.chunkMap.get(coords = new ChunkCoordIntPair((chunkX + 1) / sectionSize, (chunkZ + 1) / sectionSize))) != null) {
            return data;
        }
        data = new EnergyChunkData(chunkX, chunkZ, world.field_73012_v);
        this.chunkMap.put(coords, data);
        return data;
    }

    public EnergyChunkData getFromBlockCoords(World world, int blockX, int blockZ, boolean setModified) {
        return this.getFromChunkCoords(world, blockX >> 4, blockZ >> 4, setModified);
    }

    public void reset() {
        this.chunkMap.clear();
        this.setModified();
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ChunkCoordIntPair, EnergyChunkData> entry : this.chunkMap.entrySet()) {
            NBTTagCompound tag = entry.getValue().saveToNBT();
            tag.func_74768_a("x", entry.getKey().field_77276_a);
            tag.func_74768_a("z", entry.getKey().field_77275_b);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("sections", (NBTBase)list);
        nbt.func_74774_a("size", sectionSize);
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        if (nbt.func_74764_b("size") && nbt.func_74771_c("size") != sectionSize) {
            Log.warn("Could not load Energy savefile - expected section size of " + sectionSize + ", got " + nbt.func_74771_c("size") + " (might be intentional).", new Object[0]);
            this.setModified();
            return;
        }
        NBTTagList list = nbt.func_150295_c("sections", 10);
        int count = list.func_74745_c();
        for (int a = 0; a < count; ++a) {
            NBTTagCompound tag = list.func_150305_b(a);
            this.chunkMap.put(new ChunkCoordIntPair(tag.func_74762_e("x"), tag.func_74762_e("z")), EnergyChunkData.readFromNBT(tag));
        }
    }
}

