/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.teams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.PlayerHeadIcon;
import serverutils.lib.util.misc.MouseButton;
import serverutils.net.MessageMyTeamPlayerList;

public class GuiManagePlayersBase
extends GuiButtonListBase {
    private final List<MessageMyTeamPlayerList.Entry> entries;
    private final BiFunction<Panel, MessageMyTeamPlayerList.Entry, ButtonPlayerBase> buttonFunction;

    public GuiManagePlayersBase(String title, Collection<MessageMyTeamPlayerList.Entry> m, BiFunction<Panel, MessageMyTeamPlayerList.Entry, ButtonPlayerBase> b) {
        this.setTitle(title);
        this.setHasSearchBox(true);
        this.entries = new ArrayList<MessageMyTeamPlayerList.Entry>(m);
        this.buttonFunction = b;
    }

    @Override
    public void addButtons(Panel panel) {
        this.entries.sort(null);
        for (MessageMyTeamPlayerList.Entry m : this.entries) {
            panel.add(this.buttonFunction.apply(panel, m));
        }
    }

    public static class ButtonPlayerBase
    extends SimpleTextButton {
        final MessageMyTeamPlayerList.Entry entry;

        ButtonPlayerBase(Panel panel, MessageMyTeamPlayerList.Entry m) {
            super(panel, "", Icon.EMPTY);
            this.entry = m;
            this.updateIcon();
            this.setTitle(this.entry.name);
        }

        Color4I getPlayerColor() {
            return this.getDefaultPlayerColor();
        }

        Color4I getDefaultPlayerColor() {
            return Color4I.GRAY;
        }

        final void updateIcon() {
            this.setIcon(new PlayerHeadIcon(this.entry.uuid).withBorder(this.getPlayerColor(), false).withBorder(Color4I.DARK_GRAY, true).withPadding(2));
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }

        @Override
        public void onClicked(MouseButton button) {
        }
    }
}

