/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.util.compression.ICompress;

public class CommonsCompressor
implements ICompress {
    private ArchiveOutputStream output;

    @Override
    public void createOutputStream(File file) throws IOException {
        ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(file);
        if (ServerUtilitiesConfig.backups.compression_level == 0) {
            zaos.setMethod(0);
        } else {
            zaos.setLevel(ServerUtilitiesConfig.backups.compression_level);
        }
        this.output = zaos;
    }

    @Override
    public void addFileToArchive(File file, String name) throws IOException {
        ArchiveEntry entry = this.output.createArchiveEntry(file, name);
        this.output.putArchiveEntry(entry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)this.output);
        }
        this.output.closeArchiveEntry();
    }

    @Override
    public void close() throws Exception {
        if (this.output != null) {
            this.output.close();
        }
    }
}

