/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task;

import java.util.OptionalInt;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesTeamData;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.math.Ticks;
import serverutils.task.Task;

public class DecayTask
extends Task {
    public DecayTask() {
        super(Ticks.MINUTE.x(5L));
    }

    @Override
    public void execute(Universe universe) {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        for (ForgeTeam team : universe.getTeams()) {
            ServerUtilitiesTeamData data = ServerUtilitiesTeamData.get(team);
            if (!team.isValid() || data.getTeamChunks().isEmpty()) continue;
            if (!team.getOnlineMembers().isEmpty()) {
                team.refreshActivity();
                continue;
            }
            if (this.checkDecay(team, "serverutilities.claims.decay")) {
                ClaimedChunks.instance.unclaimAllChunks(null, team, OptionalInt.empty());
                ServerUtilities.LOGGER.info("Decaying claimed chunks for {}", new Object[]{team.getId()});
                continue;
            }
            if (data.chunkloadsDecayed || !ServerUtilitiesConfig.world.chunk_loading || !this.checkDecay(team, "serverutilities.chunkloader.decay")) continue;
            data.decayChunkloads();
            ServerUtilities.LOGGER.info("Decaying loaded chunks for {}", new Object[]{team.getId()});
        }
    }

    public boolean checkDecay(ForgeTeam team, String node) {
        long highestTimer = team.getHighestTimer(node).millis();
        long latestActivity = team.getLastActivity();
        if (latestActivity <= 0L || highestTimer <= 0L) {
            return false;
        }
        return System.currentTimeMillis() >= latestActivity + highestTimer;
    }
}

