/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.utility;

import ca.wescook.nutrition.data.PlayerDataHandler;
import ca.wescook.nutrition.nutrients.JsonNutrient;
import ca.wescook.nutrition.nutrients.NutrientList;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import ca.wescook.nutrition.utility.Config;
import ca.wescook.nutrition.utility.DataParser;
import ca.wescook.nutrition.utility.Log;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class DataImporter {
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();

    public static void reload() {
        NutrientList.register(DataParser.parseNutrients(DataImporter.loadJsonNutrients()));
        if (Config.logMissingNutrients) {
            NutrientUtils.findRegisteredFoods();
        }
    }

    public static void updatePlayerCapabilitiesOnServer(MinecraftServer server) {
        for (EntityPlayerMP player : server.func_71203_ab().field_72404_b) {
            if (server.func_71218_a((int)0).field_72995_K) continue;
            PlayerDataHandler.getForPlayer((EntityPlayer)player).update();
        }
    }

    private static List<JsonNutrient> loadJsonNutrients() {
        ArrayList nutrientFiles = Lists.newArrayList((Object[])new String[]{"dairy.json", "example.json", "fruit.json", "grain.json", "protein.json", "vegetable.json"});
        ArrayList<JsonNutrient> jsonObjectList = new ArrayList<JsonNutrient>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (String file : nutrientFiles) {
            try {
                InputStream inputStream = loader.getResourceAsStream("assets/nutrition/configs/nutrients/" + file);
                try {
                    JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(inputStream));
                    jsonObjectList.add((JsonNutrient)gson.fromJson(jsonReader, JsonNutrient.class));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JsonSyntaxException e) {
                Log.fatal("The file " + file + " has invalid JSON and could not be loaded.");
                throw new IllegalArgumentException("Unable to load " + file + ".  Is the JSON valid?", e);
            }
        }
        return jsonObjectList;
    }
}

