/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.networking.IGridHost;
import appeng.container.ContainerOpenContext;
import appeng.container.slot.SlotFake;
import com.glodblock.github.client.gui.container.ContainerPatternValueAmount;
import com.glodblock.github.client.gui.container.base.FCContainerEncodeTerminal;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.gui.PartOrItemGuiFactory;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class CPacketPatternValueSet
implements IMessage {
    private GuiType originGui;
    private int amount;
    private int valueIndex;

    public CPacketPatternValueSet() {
    }

    public CPacketPatternValueSet(int originalGui, int amount, int valueIndex) {
        this.originGui = GuiType.getByOrdinal(originalGui);
        this.amount = amount;
        this.valueIndex = valueIndex;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.originGui.ordinal());
        buf.writeInt(this.amount);
        buf.writeInt(this.valueIndex);
    }

    public void fromBytes(ByteBuf buf) {
        this.originGui = GuiType.getByOrdinal(buf.readInt());
        this.amount = buf.readInt();
        this.valueIndex = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<CPacketPatternValueSet, IMessage> {
        public IMessage onMessage(CPacketPatternValueSet message, MessageContext ctx) {
            ContainerOpenContext context;
            ContainerPatternValueAmount cpv;
            Object target;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof ContainerPatternValueAmount && (target = (cpv = (ContainerPatternValueAmount)container).getTarget()) instanceof IGridHost && (context = cpv.getOpenContext()) != null) {
                Slot slot;
                TileEntity te = context.getTile();
                if (te != null) {
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(te), Objects.requireNonNull(context.getSide()), message.originGui);
                } else if (((CPacketPatternValueSet)message).originGui.guiFactory instanceof PartOrItemGuiFactory) {
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(player.field_71071_by.field_70461_c, Util.GuiHelper.encodeType(0, Util.GuiHelper.GuiType.ITEM), 0), Objects.requireNonNull(context.getSide()), message.originGui);
                } else if (target instanceof IWirelessTerminal) {
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(((IWirelessTerminal)target).getInventorySlot(), 0, 0), Objects.requireNonNull(context.getSide()), message.originGui);
                }
                if (player.field_71070_bA instanceof FCContainerEncodeTerminal && (slot = player.field_71070_bA.func_75139_a(message.valueIndex)) instanceof SlotFake) {
                    ItemStack stack = slot.func_75211_c().func_77946_l();
                    if (Util.isFluidPacket(stack)) {
                        FluidStack fluidStack = ItemFluidPacket.getFluidStack(stack);
                        if (fluidStack != null) {
                            fluidStack = ItemFluidPacket.getFluidStack(stack).copy();
                            fluidStack.amount = message.amount;
                        }
                        slot.func_75215_d(ItemFluidPacket.newStack(fluidStack));
                    } else {
                        stack.field_77994_a = message.amount;
                        slot.func_75215_d(stack);
                    }
                }
            }
            return null;
        }
    }
}

