/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.integration;

import makeo.gadomancy.common.Gadomancy;
import makeo.gadomancy.common.integration.IntegrationMod;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class IntegrationThaumicTinkerer
extends IntegrationMod {
    private static Class infusedCropBlockClass;
    private static Class infusedCropTile;

    @Override
    public String getModId() {
        return "ThaumicTinkerer";
    }

    @Override
    public void doInit() {
        try {
            infusedCropBlockClass = Class.forName("thaumic.tinkerer.common.block.BlockInfusedGrain");
            infusedCropTile = Class.forName("thaumic.tinkerer.common.block.tile.TileInfusedGrain");
            if (infusedCropBlockClass != null && infusedCropTile != null) {
                Gadomancy.log.info("Hooked TTinkerer magic-crops");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isCropBlock(Block block) {
        if (infusedCropBlockClass == null) {
            return false;
        }
        return block.getClass().equals(infusedCropBlockClass) || infusedCropBlockClass.isAssignableFrom(block.getClass());
    }

    public static boolean isCropTile(TileEntity te) {
        if (infusedCropTile == null) {
            return false;
        }
        return te.getClass().equals(infusedCropTile) || infusedCropTile.isAssignableFrom(te.getClass());
    }
}

