/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import gcewing.architecture.ArchitectureCraftClient;
import gcewing.architecture.client.render.ICustomRenderer;
import gcewing.architecture.compat.Trans3;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderDispatcher
implements IItemRenderer {
    private final ArchitectureCraftClient baseModClient;

    public ItemRenderDispatcher(ArchitectureCraftClient baseModClient) {
        this.baseModClient = baseModClient;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        ICustomRenderer renderer = this.baseModClient.itemRenderers.get(stack.func_77973_b());
        if (renderer == null) {
            renderer = this.baseModClient.getModelRendererForItemStack(stack);
        }
        if (renderer != null) {
            Trans3 t;
            switch (type) {
                case ENTITY: {
                    t = ArchitectureCraftClient.entityTrans;
                    break;
                }
                case EQUIPPED: {
                    t = ArchitectureCraftClient.equippedTrans;
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    t = ArchitectureCraftClient.firstPersonTrans;
                    break;
                }
                case INVENTORY: {
                    t = ArchitectureCraftClient.inventoryTrans;
                    GL11.glEnable((int)3042);
                    GL11.glEnable((int)2884);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    break;
                }
                default: {
                    return;
                }
            }
            ArchitectureCraftClient.glTarget.start(false);
            renderer.renderItemStack(stack, ArchitectureCraftClient.glTarget, t);
            ArchitectureCraftClient.glTarget.finish();
            switch (type) {
                case INVENTORY: {
                    GL11.glDisable((int)3042);
                    GL11.glDisable((int)2884);
                }
            }
        }
    }
}

