/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.client.render.ICombinedRenderer;
import mods.railcraft.client.render.IIconProvider;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTESRSignals;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.signals.BlockSignalRailcraft;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderSignalBox
extends RenderTESRSignals
implements ICombinedRenderer {
    private static final RenderFakeBlock.RenderInfo info = new RenderFakeBlock.RenderInfo();
    private final IIconProvider iconProvider;
    private static final RenderFakeBlock.RenderInfo tesrInfo = new RenderFakeBlock.RenderInfo();

    public RenderSignalBox(IIconProvider iconProvider) {
        RenderSignalBox.info.texture = new IIcon[6];
        RenderSignalBox.info.template = RailcraftBlocks.getBlockSignal();
        RenderSignalBox.tesrInfo.texture = new IIcon[6];
        RenderSignalBox.tesrInfo.template = RailcraftBlocks.getBlockSignal();
        this.iconProvider = iconProvider;
    }

    @Override
    public void renderBlock(RenderBlocks renderblocks, IBlockAccess iBlockAccess, int x, int y, int z, Block block) {
        float maxZNS;
        TileBoxBase tile = (TileBoxBase)iBlockAccess.func_147438_o(x, y, z);
        float pix = 0.0625f;
        RenderSignalBox.info.override = renderblocks.func_147744_b() ? renderblocks.field_147840_d : null;
        RenderSignalBox.info.texture[0] = BlockSignalRailcraft.texturesBox[2];
        RenderSignalBox.info.texture[1] = this.iconProvider.getIcon();
        RenderSignalBox.info.texture[2] = BlockSignalRailcraft.texturesBox[0];
        RenderSignalBox.info.texture[3] = BlockSignalRailcraft.texturesBox[0];
        RenderSignalBox.info.texture[4] = BlockSignalRailcraft.texturesBox[0];
        RenderSignalBox.info.texture[5] = BlockSignalRailcraft.texturesBox[0];
        boolean eastWest = false;
        boolean northSouth = false;
        if (tile.isConnected(ForgeDirection.EAST) || tile.isConnected(ForgeDirection.WEST)) {
            eastWest = true;
        }
        if (tile.isConnected(ForgeDirection.NORTH) || tile.isConnected(ForgeDirection.SOUTH)) {
            northSouth = true;
        }
        boolean side2 = tile.isConnected(ForgeDirection.NORTH);
        boolean side3 = tile.isConnected(ForgeDirection.SOUTH);
        boolean side4 = tile.isConnected(ForgeDirection.WEST);
        boolean side5 = tile.isConnected(ForgeDirection.EAST);
        if (!eastWest && !northSouth) {
            eastWest = true;
        }
        if (side2) {
            RenderSignalBox.info.texture[2] = BlockSignalRailcraft.texturesBox[1];
        }
        if (side3) {
            RenderSignalBox.info.texture[3] = BlockSignalRailcraft.texturesBox[1];
        }
        if (side4) {
            RenderSignalBox.info.texture[4] = BlockSignalRailcraft.texturesBox[1];
        }
        if (side5) {
            RenderSignalBox.info.texture[5] = BlockSignalRailcraft.texturesBox[1];
        }
        info.setBlockBounds(2.0f * pix, 0.0f, 2.0f * pix, 14.0f * pix, 15.0f * pix, 14.0f * pix);
        RenderFakeBlock.renderBlock(info, iBlockAccess, x, y, z, true, false);
        RenderSignalBox.info.renderSide[0] = false;
        RenderSignalBox.info.renderSide[1] = false;
        RenderSignalBox.info.brightness = -1;
        info.setRenderAllSides();
        if (!iBlockAccess.func_147437_c(x, y + 1, z)) {
            RenderSignalBox.info.texture[1] = BlockSignalRailcraft.texturesBox[3];
            RenderSignalBox.info.texture[2] = BlockSignalRailcraft.texturesBox[0];
            RenderSignalBox.info.texture[3] = BlockSignalRailcraft.texturesBox[0];
            RenderSignalBox.info.texture[4] = BlockSignalRailcraft.texturesBox[0];
            RenderSignalBox.info.texture[5] = BlockSignalRailcraft.texturesBox[0];
            info.setBlockBounds(5.0f * pix, 15.0f * pix, 5.0f * pix, 11.0f * pix, 16.0f * pix, 11.0f * pix);
            RenderFakeBlock.renderBlock(info, iBlockAccess, x, y, z, true, false);
        }
        RenderSignalBox.info.texture[0] = BlockSignalRailcraft.texturesBox[4];
        RenderSignalBox.info.texture[1] = BlockSignalRailcraft.texturesBox[4];
        RenderSignalBox.info.texture[2] = BlockSignalRailcraft.texturesBox[5];
        RenderSignalBox.info.texture[3] = BlockSignalRailcraft.texturesBox[5];
        RenderSignalBox.info.texture[4] = BlockSignalRailcraft.texturesBox[5];
        RenderSignalBox.info.texture[5] = BlockSignalRailcraft.texturesBox[5];
        float min = 7.0f * pix;
        float max = 9.0f * pix;
        float minY = 10.0f * pix;
        float maxY = 12.0f * pix;
        float minXEW = side4 ? 0.0f : min;
        float maxXEW = side5 ? 1.0f : max;
        float minZNS = side2 ? 0.0f : min;
        float f = maxZNS = side3 ? 1.0f : max;
        if (eastWest) {
            info.setBlockBounds(minXEW, minY, min, maxXEW, maxY, max);
            RenderFakeBlock.renderBlock(info, iBlockAccess, x, y, z, true, false);
        }
        if (northSouth) {
            info.setBlockBounds(min, minY, minZNS, max, maxY, maxZNS);
            RenderFakeBlock.renderBlock(info, iBlockAccess, x, y, z, true, false);
        }
        minY = 5.0f * pix;
        maxY = 7.0f * pix;
        if (eastWest) {
            info.setBlockBounds(minXEW, minY, min, maxXEW, maxY, max);
            RenderFakeBlock.renderBlock(info, iBlockAccess, x, y, z, true, false);
        }
        if (northSouth) {
            info.setBlockBounds(min, minY, minZNS, max, maxY, maxZNS);
            RenderFakeBlock.renderBlock(info, iBlockAccess, x, y, z, true, false);
        }
    }

    @Override
    public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderSignalBox.info.override = null;
        float pix = 0.0625f;
        info.setBlockBounds(2.0f * pix, 0.0f, 2.0f * pix, 14.0f * pix, 15.0f * pix, 14.0f * pix);
        RenderSignalBox.info.texture[0] = BlockSignalRailcraft.texturesBox[2];
        RenderSignalBox.info.texture[1] = this.iconProvider.getIcon();
        RenderSignalBox.info.texture[2] = BlockSignalRailcraft.texturesBox[0];
        RenderSignalBox.info.texture[3] = BlockSignalRailcraft.texturesBox[0];
        RenderSignalBox.info.texture[4] = BlockSignalRailcraft.texturesBox[0];
        RenderSignalBox.info.texture[5] = BlockSignalRailcraft.texturesBox[0];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, info, 1.0f);
        int texture = SignalAspect.RED.getTextureIndex();
        RenderSignalBox.info.renderSide[0] = false;
        RenderSignalBox.info.renderSide[1] = false;
        RenderSignalBox.info.texture[2] = BlockSignalRailcraft.texturesLampBox[texture];
        RenderSignalBox.info.texture[3] = BlockSignalRailcraft.texturesLampBox[texture];
        RenderSignalBox.info.texture[4] = BlockSignalRailcraft.texturesLampBox[texture];
        RenderSignalBox.info.texture[5] = BlockSignalRailcraft.texturesLampBox[texture];
        RenderFakeBlock.renderBlockOnInventory(renderblocks, info, 1.0f);
        info.setRenderAllSides();
        GL11.glPopAttrib();
    }

    @Override
    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        super.func_147500_a(te, x, y, z, f);
        if (!(te instanceof TileBoxBase)) {
            return;
        }
        RenderFakeBlock.RenderInfo info = tesrInfo;
        TileBoxBase tile = (TileBoxBase)te;
        info.renderSide[0] = false;
        info.renderSide[1] = false;
        info.renderSide[2] = !tile.isConnected(ForgeDirection.NORTH);
        info.renderSide[3] = !tile.isConnected(ForgeDirection.SOUTH);
        info.renderSide[4] = !tile.isConnected(ForgeDirection.WEST);
        info.renderSide[5] = !tile.isConnected(ForgeDirection.EAST);
        for (int side = 2; side < 6; ++side) {
            SignalAspect aspect = tile.getBoxSignalAspect(ForgeDirection.getOrientation((int)side));
            if (!aspect.isLit()) {
                aspect = SignalAspect.OFF;
            }
            info.texture[side] = BlockSignalRailcraft.texturesLampBox[aspect.getTextureIndex()];
            info.brightness = aspect.getTextureBrightness();
        }
        RenderSignalBox.doRenderAspect(info, tile, x, y, z);
    }
}

