/*
 * Decompiled with CFR 0.152.
 */
package thaumicinsurgence.main.utils.compat;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.config.ConfigItems;
import thaumicinsurgence.main.Config;
import thaumicinsurgence.main.utils.BlockInterface;
import thaumicinsurgence.main.utils.ItemInterface;
import thaumicinsurgence.main.utils.LocalizationManager;
import thaumicinsurgence.main.utils.compat.IModHelper;

public class ThaumcraftHelper
implements IModHelper {
    public static Block plant;
    public static Block candle;
    public static Block crystal;
    public static Block marker;
    public static Block jar;
    public static Block log;
    public static Block leaf;
    public static Block warded;
    public static Block wooden;
    public static Block metal;
    public static Block airy;
    public static Item filledJar;
    public static Item miscResource;
    public static Item shard;
    public static Item golem;
    public static Item nuggetMetal;
    public static Item nuggetChicken;
    public static Item nuggetBeef;
    public static Item nuggetPork;
    public static Item zombieBrain;
    public static final String Name = "Thaumcraft";
    public static InfusionRecipe infusionIntercepter;
    public static InfusionRecipe thaumicInterfacer;
    public static CrucibleRecipe soapAlpha;
    public static CrucibleRecipe soapBeta;
    public static CrucibleRecipe bigShot;

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        ThaumcraftHelper.getBlocks();
        ThaumcraftHelper.getItems();
    }

    @Override
    public void postInit() {
        ThaumcraftHelper.setupItemAspects();
        ThaumcraftHelper.setupCrafting();
        ThaumcraftHelper.setupResearch();
    }

    public static void getBlocks() {
        plant = BlockInterface.getBlock(Name, "blockCustomPlant");
        candle = BlockInterface.getBlock(Name, "blockCandle");
        crystal = BlockInterface.getBlock(Name, "blockCrystal");
        marker = BlockInterface.getBlock(Name, "blockMarker");
        jar = BlockInterface.getBlock(Name, "blockJar");
        log = BlockInterface.getBlock(Name, "blockMagicalLog");
        leaf = BlockInterface.getBlock(Name, "blockMagicalLeaves");
        warded = BlockInterface.getBlock(Name, "blockWarded");
        wooden = BlockInterface.getBlock(Name, "blockWoodenDevice");
        metal = BlockInterface.getBlock(Name, "blockMetalDevice");
        airy = BlockInterface.getBlock(Name, "blockAiry");
    }

    public static void getItems() {
        filledJar = ItemInterface.getItem(Name, "BlockJarFilledItem");
        miscResource = ItemInterface.getItem(Name, "ItemResource");
        shard = ItemInterface.getItem(Name, "ItemShard");
        golem = ItemInterface.getItem(Name, "ItemGolemPlacer");
        nuggetMetal = ItemInterface.getItem(Name, "ItemNugget");
        shard = ItemInterface.getItem(Name, "ItemShard");
        nuggetChicken = ItemInterface.getItem(Name, "ItemNuggetChicken");
        nuggetBeef = ItemInterface.getItem(Name, "ItemNuggetBeef");
        nuggetPork = ItemInterface.getItem(Name, "ItemNuggetPork");
        zombieBrain = ItemInterface.getItem(Name, "ItemZombieBrain");
    }

    public static void setupCrafting() {
        infusionIntercepter = ThaumcraftApi.addInfusionCraftingRecipe((String)"TI_InfusionIntercepter", (Object)new ItemStack((Block)Config.infusionIntercepter), (int)10, (AspectList)new AspectList().add(Aspect.MAGIC, 100).add(Aspect.HUNGER, 100).add(Aspect.TOOL, 75).add(Aspect.TRAP, 50).add(Aspect.MECHANISM, 50).add(Aspect.EXCHANGE, 25), (ItemStack)new ItemStack(metal, 1, MetalDeviceType.ALCHEMICAL_CONSTRUCT.ordinal()), (ItemStack[])new ItemStack[]{new ItemStack(metal, 1, MetalDeviceType.ALEMBIC.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALCHEMICAL_CONSTRUCT.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALEMBIC.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALCHEMICAL_CONSTRUCT.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALEMBIC.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALCHEMICAL_CONSTRUCT.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALEMBIC.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALCHEMICAL_CONSTRUCT.ordinal())});
        thaumicInterfacer = ThaumcraftApi.addInfusionCraftingRecipe((String)"TI_ThaumicInterfacer", (Object)new ItemStack(Config.thaumicInterfacer), (int)64, (AspectList)new AspectList().add(Aspect.FIRE, 8), (ItemStack)new ItemStack(ConfigItems.itemThaumometer), (ItemStack[])new ItemStack[]{new ItemStack(metal, 1, MetalDeviceType.ALEMBIC.ordinal()), new ItemStack(metal, 1, MetalDeviceType.ALEMBIC.ordinal())});
        soapAlpha = ThaumcraftApi.addCrucibleRecipe((String)"TI_SanitizingSoapAlpha", (ItemStack)new ItemStack(Config.soapAlpha), (Object)new ItemStack(ConfigItems.itemSanitySoap), (AspectList)new AspectList().add(Aspect.HEAL, 16).add(Aspect.ORDER, 32));
        soapBeta = ThaumcraftApi.addCrucibleRecipe((String)"TI_SanitizingSoapBeta", (ItemStack)new ItemStack(Config.soapBetaBitch), (Object)new ItemStack(Config.soapAlpha), (AspectList)new AspectList().add(Aspect.ELDRITCH, 16).add(Aspect.EXCHANGE, 32).add(Aspect.HEAL, 32));
        bigShot = ThaumcraftApi.addCrucibleRecipe((String)"TI_DeliciousKromer", (ItemStack)new ItemStack(Config.hyperLinkBlocked), (Object)new ItemStack(ConfigItems.itemGoggles), (AspectList)new AspectList().add(Aspect.GREED, 128).add(Aspect.ELDRITCH, 64).add(Aspect.DARKNESS, 64).add(Aspect.EXCHANGE, 64).add(Aspect.TRAP, 32));
    }

    public static void setupResearch() {
        String category = "THAUMICINSURGENCE";
        ResearchCategories.registerCategory((String)category, (ResourceLocation)new ResourceLocation("thaumicinsurgence", "textures/items/silverwood_filter.png"), (ResourceLocation)new ResourceLocation("thaumicinsurgence", "textures/gui/eldritch_bg.png"));
        ResearchItem soapAlphaPage = new ResearchItem("TI_SanitizingSoapAlpha", category, new AspectList().add(Aspect.HEAL, 1).add(Aspect.ORDER, 1), 2, 2, 2, new ItemStack(Config.soapAlpha));
        ResearchItem soapBetaPage = new ResearchItem("TI_SanitizingSoapBeta", category, new AspectList().add(Aspect.ELDRITCH, 1).add(Aspect.EXCHANGE, 1).add(Aspect.HEAL, 1), -2, 2, 2, new ItemStack(Config.soapBetaBitch));
        ResearchItem infusionIntercepterPage = new ResearchItem("TI_InfusionIntercepter", category, new AspectList().add(Aspect.MAGIC, 1).add(Aspect.HUNGER, 1).add(Aspect.TOOL, 1).add(Aspect.TRAP, 1).add(Aspect.MECHANISM, 1).add(Aspect.EXCHANGE, 1), 0, 0, 0, new ItemStack((Block)Config.infusionIntercepter));
        ResearchItem redCrownPage = new ResearchItem("TI_RedCrown", category, new AspectList(), 5, 5, 5, new ItemStack(Config.eightBitRedCrownItem));
        ResearchItem thaumicInterfacerPage = new ResearchItem("TI_ThaumicInterfacer", category, new AspectList().add(Aspect.FIRE, 1).add(Aspect.TOOL, 1), -5, 5, -5, new ItemStack(Config.thaumicInterfacer));
        ResearchItem littleSponge = new ResearchItem("TI_DeliciousKromer", category, new AspectList().add(Aspect.GREED, 1).add(Aspect.ELDRITCH, 1).add(Aspect.DARKNESS, 1).add(Aspect.EXCHANGE, 1).add(Aspect.TRAP, 1), 0, 3, 0, new ItemStack(Config.hyperLinkBlocked));
        ResearchPage intercepter1 = new ResearchPage("InfusionIntercepter.1");
        ResearchPage intercepter2 = new ResearchPage(infusionIntercepter);
        ResearchPage redCrown1 = new ResearchPage("RedCrown.1");
        ResearchPage thaumicInterfacer1 = new ResearchPage("ThaumicInterfacer.1");
        ResearchPage thaumicInterface2 = new ResearchPage(thaumicInterfacer);
        ResearchPage soapAlpha1 = new ResearchPage("SoapAlpha.1");
        ResearchPage soapAlpha2 = new ResearchPage(soapAlpha);
        ResearchPage soapBeta1 = new ResearchPage("SoapBeta.1");
        ResearchPage soapBeta2 = new ResearchPage("SoapBeta.2");
        ResearchPage soapBeta3 = new ResearchPage(soapBeta);
        ResearchPage unintelligbleLaughter = new ResearchPage("unintelligbleLaughter");
        ResearchPage shootForTheSky = new ResearchPage(bigShot);
        infusionIntercepterPage.setPages(new ResearchPage[]{intercepter1, intercepter2});
        infusionIntercepterPage.setParents(new String[]{"INFUSION"});
        redCrownPage.setPages(new ResearchPage[]{redCrown1});
        redCrownPage.setParents(new String[]{"TI_RedCrown"});
        thaumicInterfacerPage.setPages(new ResearchPage[]{thaumicInterfacer1, thaumicInterface2});
        thaumicInterfacerPage.setParents(new String[]{"INFUSION"});
        soapAlphaPage.setPages(new ResearchPage[]{soapAlpha1, soapAlpha2});
        soapAlphaPage.setParents(new String[]{"SANESOAP"});
        soapBetaPage.setPages(new ResearchPage[]{soapBeta1, soapBeta2, soapBeta3});
        soapBetaPage.setParents(new String[]{"TI_SanitizingSoapAlpha"});
        littleSponge.setPages(new ResearchPage[]{unintelligbleLaughter, shootForTheSky});
        littleSponge.setParents(new String[]{"GOGGLES"});
        ThaumcraftApi.addWarpToResearch((String)"TI_InfusionIntercepter", (int)4);
        ResearchCategories.addResearch((ResearchItem)infusionIntercepterPage);
        ResearchCategories.addResearch((ResearchItem)thaumicInterfacerPage);
        ResearchCategories.addResearch((ResearchItem)soapAlphaPage);
        ResearchCategories.addResearch((ResearchItem)soapBetaPage);
        ResearchCategories.addResearch((ResearchItem)littleSponge);
    }

    public static ResearchPage getResearchPage(String ident) {
        return new ResearchPage(LocalizationManager.getLocalizedString("tc.research_page." + ident));
    }

    public static void setupItemAspects() {
    }

    public static enum TreeType {
        GREATWOOD,
        SILVERWOOD;

    }

    public static enum BlockPlant {
        GREATWOOD_SAPLING,
        SILVERWOOD_SAPLING,
        SHIMMERLEAF,
        CINDERPEARL,
        PURIFYING_PLANT,
        VISHROOM;

    }

    public static enum Entity {
        BRAINY_ZOMBIE("entBrainyZombie", "EntityBrainyZombie"),
        GIANT_BRAINY_ZOMBIE("entGiantBrainyZombie", "EntityGiantBrainyZombie"),
        WISP("entWisp", "EntityWisp"),
        FIREBAT("entFirebat", "EntityFireBat");

        private static final String packageName = "thaumcraft.common.entities.monster.";
        public final String entityID;
        private final String className;

        private Entity(String id, String clazz) {
            this.entityID = id;
            this.className = clazz;
        }

        public String getClassName() {
            return packageName + this.className;
        }
    }

    public static enum AiryBlockType {
        NODE,
        NITOR,
        _2,
        _3,
        WARDING_STONE_FENCE,
        ENERGIZED_NODE;

    }

    public static enum WoodenDeviceType {
        BELLOWS,
        EAR,
        PRESSURE_PLATE,
        PRESSURE_PLATE_B,
        BORE_BASE,
        BORE,
        PLANKS_GREATWOOD,
        PLANKS_SILVERWOOD,
        BANNER;

    }

    public static enum MetalDeviceType {
        CRUCIBLE,
        ALEMBIC,
        VIS_CHARGE_RELAY,
        ADVANCED_ALCHEMICAL_CONSTRUCT,
        _4,
        ITEM_GRATE,
        _6,
        ARCANE_LAMP,
        LAMP_OF_GROWTH,
        ALCHEMICAL_CONSTRUCT,
        THAUMATORIUM,
        _11,
        MNEMONIC_MATRIX,
        LAMP_OF_FERTILITY,
        VIS_RELAY;

    }

    public static enum ShardType {
        AIR,
        FIRE,
        WATER,
        EARTH,
        ORDER,
        CHAOS,
        BALANCED;

    }

    public static enum NuggetType {
        IRON,
        COPPER,
        TIN,
        SILVER,
        LEAD,
        QUICKSILVER,
        THAUMIUM,
        VOID_METAL,
        _8,
        _9,
        _10,
        _11,
        _12,
        _13,
        _14,
        _15,
        NATIVE_IRON,
        NATIVE_COPPER,
        NATIVE_TIN,
        NATIVE_SILVER,
        NATIVE_LEAD,
        NATIVE_CINNABAR,
        _22,
        _23,
        _24,
        _25,
        _26,
        _27,
        _28,
        _29,
        _30,
        NATIVE_GOLD;

    }

    public static enum MiscResource {
        ALUMENTUM,
        NITOR,
        THAUMIUM,
        QUICKSILVER,
        MAGIC_TALLOW,
        BRAIN_DEPRECATED,
        AMBER,
        ENCHANTED_FABRIC,
        VIS_FILTER,
        KNOWLEDGE_FRAGMENT,
        MIRRORED_GLASS,
        TAINTED_GOO,
        TAINTED_TENDRIL,
        JAR_LABEL,
        SALIS,
        CHARM,
        VOID_INGOT,
        VOID_SEED,
        COIN;

    }
}

