/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.gtnewhorizons.gtnhintergalactic.recipe.IGRecipeMaps;
import com.gtnewhorizons.gtnhintergalactic.recipe.ResultNoSpaceProject;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevator.ElevatorUtil;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.ModuleOverclockDescriber;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.MultiblockTooltipBuilder;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public abstract class TileEntityModuleAssembler
extends TileEntityModuleBase
implements IOverclockDescriptionProvider {
    private static final INameFunction<TileEntityModuleAssembler> PARALLEL_SETTING_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.cfgi.0");
    private static final IStatusFunction<TileEntityModuleAssembler> PARALLEL_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)0.0, (double)1.0, (double)100.0, (double)base.getMaxParallels(), (double[])new double[0]);
    protected final OverclockDescriber overclockDescriber;
    Parameters.Group.ParameterIn parallelSetting;
    protected static Textures.BlockIcons.CustomIcon engraving;

    public TileEntityModuleAssembler(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aID, aName, aNameRegional, tTier, tModuleTier, tMinMotorTier, bufferSizeMultiplier);
        this.overclockDescriber = new ModuleOverclockDescriber((byte)tTier, tModuleTier);
    }

    public TileEntityModuleAssembler(String aName, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aName, tTier, tModuleTier, tMinMotorTier, bufferSizeMultiplier);
        this.overclockDescriber = new ModuleOverclockDescriber((byte)tTier, tModuleTier);
    }

    protected abstract int getMaxParallels();

    public OverclockDescriber getOverclockDescriber() {
        return this.overclockDescriber;
    }

    public RecipeMap<?> getRecipeMap() {
        return IGRecipeMaps.spaceAssemblerRecipes;
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTValues.V[this.tTier]);
        logic.setAvailableAmperage((long)this.getMaxParallels());
    }

    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (this.lastRecipe != recipe) {
                    String neededProject = (String)recipe.getMetadata(IGRecipeMaps.SPACE_PROJECT);
                    String neededLocation = (String)recipe.getMetadata(IGRecipeMaps.SPACE_LOCATION);
                    if (!ElevatorUtil.isProjectAvailable(TileEntityModuleAssembler.this.getBaseMetaTileEntity().getOwnerUuid(), neededProject, neededLocation)) {
                        return new ResultNoSpaceProject(neededProject, neededLocation);
                    }
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        }.setAmperageOC(false)).setMaxParallelSupplier(() -> Math.min(this.getMaxParallels(), (int)this.parallelSetting.get()));
    }

    @Override
    protected void parametersInstantiation_EM() {
        super.parametersInstantiation_EM();
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, false);
        this.parallelSetting = hatch_0.makeInParameter(0, (double)this.getMaxParallels(), PARALLEL_SETTING_NAME, PARALLEL_STATUS);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), new TTRenderedExtendedFacingTexture((IIconContainer)(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF))};
        }
        if (facing.getRotation(ForgeDirection.UP) == side || facing.getRotation(ForgeDirection.DOWN) == side) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), new TTRenderedExtendedFacingTexture((IIconContainer)engraving)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096)};
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        engraving = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_SIDE_ASSEMBLER_MODULE");
        super.registerIcons(aBlockIconRegister);
    }

    public boolean protectsExcessItem() {
        return !this.eSafeVoid;
    }

    public boolean protectsExcessFluid() {
        return !this.eSafeVoid;
    }

    public static class TileEntityModuleAssemblerT3
    extends TileEntityModuleAssembler {
        protected static final int MODULE_VOLTAGE_TIER = 13;
        protected static final int MODULE_TIER = 3;
        protected static final int MINIMUM_MOTOR_TIER = 5;
        protected static final int MAX_PARALLELS = 64;

        public TileEntityModuleAssemblerT3(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 13, 3, 5, 64);
        }

        public TileEntityModuleAssemblerT3(String aName) {
            super(aName, 13, 3, 5, 64);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleAssemblerT3(this.mName);
        }

        @Override
        protected int getMaxParallels() {
            return 64;
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.t3.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.t3.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT5")).beginStructureBlock(1, 5, 2, false).addCasingInfoMin(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }

    public static class TileEntityModuleAssemblerT2
    extends TileEntityModuleAssembler {
        protected static final int MODULE_VOLTAGE_TIER = 11;
        protected static final int MODULE_TIER = 2;
        protected static final int MINIMUM_MOTOR_TIER = 3;
        protected static final int MAX_PARALLELS = 16;

        public TileEntityModuleAssemblerT2(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 11, 2, 3, 16);
        }

        public TileEntityModuleAssemblerT2(String aName) {
            super(aName, 11, 2, 3, 16);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleAssemblerT2(this.mName);
        }

        @Override
        protected int getMaxParallels() {
            return 16;
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.t2.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.t2.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT3")).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, 9, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }

    public static class TileEntityModuleAssemblerT1
    extends TileEntityModuleAssembler {
        protected static final int MODULE_VOLTAGE_TIER = 9;
        protected static final int MODULE_TIER = 1;
        protected static final int MINIMUM_MOTOR_TIER = 1;
        protected static final int MAX_PARALLELS = 4;

        public TileEntityModuleAssemblerT1(int aID, String aName, String aNameRegional) {
            super(aID, aName, aNameRegional, 9, 1, 1, 4);
        }

        public TileEntityModuleAssemblerT1(String aName) {
            super(aName, 9, 1, 1, 4);
        }

        public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
            return new TileEntityModuleAssemblerT1(this.mName);
        }

        @Override
        protected int getMaxParallels() {
            return 4;
        }

        @Override
        protected MultiblockTooltipBuilder createTooltip() {
            MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
            tt.addMachineType(GCCoreUtil.translate((String)"gt.blockmachines.module.name")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.desc0")).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.t1.desc1")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.assembler.t1.desc2")).addInfo(GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.motorT1")).beginStructureBlock(1, 5, 2, false).addCasingInfoMin(GCCoreUtil.translate((String)"gt.blockcasings.ig.0.name"), 0, false).addInputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputBus(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addInputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).addOutputHatch(GCCoreUtil.translate((String)"ig.elevator.structure.AnyBaseCasingWith1Dot"), new int[]{1}).toolTipFinisher(new String[0]);
            return tt;
        }
    }
}

