/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.gui.popup.SelectItemOutOfList;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.NEISetCraftingRecipe;
import logisticspipes.network.packets.pipe.FindMostLikelyRecipeComponents;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.SimpleGraphics;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class GuiRecipeImport
extends SubGuiScreen {
    private final RenderItem itemRenderer = new RenderItem();
    private final TileEntity tile;
    private final Canidates[] grid = new Canidates[9];
    private final List<Canidates> list;
    private Object[] tooltip = null;

    public GuiRecipeImport(TileEntity tile, ItemStack[][] stacks) {
        super(150, 200, 0, 0);
        this.tile = tile;
        this.list = new ArrayList<Canidates>();
        for (int i = 0; i < 9; ++i) {
            if (stacks[i] == null) continue;
            TreeSet<ItemIdentifierStack> part = new TreeSet<ItemIdentifierStack>();
            ArrayList<ItemIdentifierStack> order = new ArrayList<ItemIdentifierStack>();
            for (ItemStack stack : stacks[i]) {
                ItemIdentifierStack iStack = ItemIdentifierStack.getFromStack(stack);
                part.add(iStack);
                order.add(iStack);
            }
            Canidates canidate = new Canidates(part);
            boolean found = false;
            for (Canidates test : this.list) {
                if (!test.set.equals(part)) continue;
                canidate = test;
                found = true;
                break;
            }
            if (!found) {
                canidate.order = order;
                if (order.size() > 1) {
                    this.list.add(canidate);
                }
            }
            this.grid[i] = canidate;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.guiLeft + 100, this.guiTop + 180, 40, 10, "Done"));
        this.field_146292_n.add(new SmallGuiButton(1, this.guiLeft + 10, this.guiTop + 180, 60, 10, "Most likely"));
        int x = 0;
        int y = 0;
        for (Canidates canidate : this.list) {
            this.field_146292_n.add(new SmallGuiButton(10 + x + y * 3, this.guiLeft + 38 + x * 40, this.guiTop + 88 + y * 40, 15, 10, "/\\"));
            this.field_146292_n.add(new SmallGuiButton(20 + x + y * 3, this.guiLeft + 38 + x * 40, this.guiTop + 98 + y * 40, 15, 10, "\\/"));
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
    }

    @Override
    protected void renderToolTips(int mouseX, int mouseY, float par3) {
        GuiGraphics.displayItemToolTip(this.tooltip, (Gui)this, this.field_73735_i, this.guiLeft, this.guiTop);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int y;
        int x;
        this.field_146289_q.func_78258_a(StringUtils.translate("misc.selectOreDict"), this.guiLeft + 10, this.guiTop + 6, 0x404040, false);
        this.tooltip = null;
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                if (this.grid[x + y * 3] == null) continue;
                ItemIdentifierStack stack = this.grid[x + y * 3].order.get(this.grid[x + y * 3].pos);
                ItemStack itemStack = stack.makeNormalStack();
                FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
                if (font == null) {
                    font = this.field_146289_q;
                }
                this.itemRenderer.func_82406_b(font, this.field_146297_k.field_71446_o, itemStack, this.guiLeft + 45 + x * 18, this.guiTop + 20 + y * 18);
                this.itemRenderer.func_94148_a(font, this.field_146297_k.field_71446_o, itemStack, this.guiLeft + 45 + x * 18, this.guiTop + 20 + y * 18, null);
                if (this.guiLeft + 45 + x * 18 >= mouseX || mouseX >= this.guiLeft + 45 + x * 18 + 16 || this.guiTop + 20 + y * 18 >= mouseY || mouseY >= this.guiTop + 20 + y * 18 + 16 || this.hasSubGui()) continue;
                SimpleGraphics.drawGradientRect(this.guiLeft + 45 + x * 18, this.guiTop + 20 + y * 18, this.guiLeft + 45 + x * 18 + 16, this.guiTop + 20 + y * 18 + 16, Color.WHITE_50, Color.WHITE_50, 0.0);
                this.tooltip = new Object[]{this.guiLeft + mouseX, this.guiTop + mouseY, itemStack};
            }
        }
        x = 0;
        y = 0;
        for (Canidates canidate : this.list) {
            ItemIdentifierStack stack = canidate.order.get(canidate.pos);
            ItemStack itemStack = stack.makeNormalStack();
            FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
            if (font == null) {
                font = this.field_146289_q;
            }
            this.itemRenderer.func_82406_b(font, this.field_146297_k.field_71446_o, itemStack, this.guiLeft + 20 + x * 40, this.guiTop + 90 + y * 40);
            this.itemRenderer.func_94148_a(font, this.field_146297_k.field_71446_o, itemStack, this.guiLeft + 20 + x * 40, this.guiTop + 90 + y * 40, "");
            if (this.guiLeft + 20 + x * 40 < mouseX && mouseX < this.guiLeft + 20 + x * 40 + 16 && this.guiTop + 90 + y * 40 < mouseY && mouseY < this.guiTop + 90 + y * 40 + 16 && !this.hasSubGui()) {
                SimpleGraphics.drawGradientRect(this.guiLeft + 20 + x * 40, this.guiTop + 90 + y * 40, this.guiLeft + 20 + x * 40 + 16, this.guiTop + 90 + y * 40 + 16, Color.WHITE_50, Color.WHITE_50, 0.0);
                this.tooltip = new Object[]{this.guiLeft + mouseX, this.guiTop + mouseY, itemStack};
            }
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
    }

    @Override
    protected void renderGuiBackground(int par1, int par2) {
        int y;
        int x;
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        this.field_146289_q.func_78258_a(StringUtils.translate("misc.selectOreDict"), this.guiLeft + 10, this.guiTop + 6, 0x404040, false);
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.guiLeft + 44 + x * 18, this.guiTop + 19 + y * 18);
            }
        }
        x = 0;
        y = 0;
        for (Canidates canidate : this.list) {
            GuiGraphics.drawSlotBackground(this.field_146297_k, this.guiLeft + 19 + x * 40, this.guiTop + 89 + y * 40);
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            ItemStack[] stack = new ItemStack[9];
            int i = 0;
            for (Canidates canidate : this.grid) {
                if (canidate == null) {
                    ++i;
                    continue;
                }
                stack[i++] = canidate.order.get(canidate.pos).makeNormalStack();
            }
            NEISetCraftingRecipe packet = PacketHandler.getPacket(NEISetCraftingRecipe.class);
            MainProxy.sendPacketToServer(packet.setContent(stack).setPosX(this.tile.field_145851_c).setPosY(this.tile.field_145848_d).setPosZ(this.tile.field_145849_e));
            this.exitGui();
        } else if (id == 1) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(FindMostLikelyRecipeComponents.class).setContent(this.list).setTilePos(this.tile));
        } else if (id >= 10 && id < 30) {
            int slot = id % 10;
            boolean up = id < 20;
            Canidates canidate = this.list.get(slot);
            if (up) {
                ++canidate.pos;
                if (canidate.pos >= canidate.order.size()) {
                    canidate.pos = 0;
                }
            } else {
                --canidate.pos;
                if (canidate.pos < 0) {
                    canidate.pos = canidate.order.size() - 1;
                }
            }
        }
    }

    public void handleProposePacket(List<Integer> response) {
        if (this.list.size() != response.size()) {
            return;
        }
        for (int slot = 0; slot < this.list.size(); ++slot) {
            Canidates canidate = this.list.get(slot);
            int newPos = response.get(slot);
            if (newPos == -1) continue;
            canidate.pos = newPos;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        int x = 0;
        int y = 0;
        for (Canidates canidate : this.list) {
            if (this.guiLeft + 20 + x * 40 < mouseX && mouseX < this.guiLeft + 20 + x * 40 + 16 && this.guiTop + 90 + y * 40 < mouseY && mouseY < this.guiTop + 90 + y * 40 + 16) {
                this.setSubGui(new SelectItemOutOfList(canidate.order, slot -> {
                    canidate.pos = slot;
                }));
            }
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    public static class Canidates {
        Set<ItemIdentifierStack> set;
        public List<ItemIdentifierStack> order;
        int pos = 0;

        public Canidates(Set<ItemIdentifierStack> set) {
            this.set = set;
        }
    }
}

