/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeListener;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.blocks.BlockAlveary;
import forestry.apiculture.gui.ContainerAlvearySieve;
import forestry.apiculture.gui.GuiAlvearySieve;
import forestry.apiculture.inventory.InventoryAlvearySieve;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class TileAlvearySieve
extends TileAlveary
implements IAlvearyComponent.BeeListener {
    private final IBeeListener beeListener;
    private final InventoryAlvearySieve inventory = new InventoryAlvearySieve(this);

    public TileAlvearySieve() {
        super(BlockAlveary.Type.SIEVE);
        this.beeListener = new AlvearySieveBeeListener(this.inventory);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    public ISlotPickupWatcher getCrafter() {
        return this.inventory;
    }

    @Override
    public IBeeListener getBeeListener() {
        return this.beeListener;
    }

    @Override
    public int getIcon(int side) {
        if (side == 0 || side == 1) {
            return 2;
        }
        return 13;
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiAlvearySieve(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerAlvearySieve(player.field_71071_by, this);
    }

    static class AlvearySieveBeeListener
    extends DefaultBeeListener {
        private final InventoryAlvearySieve inventory;

        public AlvearySieveBeeListener(InventoryAlvearySieve inventory) {
            this.inventory = inventory;
        }

        @Override
        public boolean onPollenRetrieved(IIndividual pollen) {
            if (!this.inventory.canStorePollen()) {
                return false;
            }
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(pollen.getClass());
            ItemStack pollenStack = speciesRoot.getMemberStack(pollen, EnumGermlingType.POLLEN.ordinal());
            if (pollenStack != null) {
                this.inventory.storePollenStack(pollenStack);
                return true;
            }
            return false;
        }
    }
}

