/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import forestry.api.core.ForestryAPI;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.tiles.TileEngine;
import forestry.core.utils.BlockUtil;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyManager
implements IEnergyHandler,
IStreamable {
    private final EnergyStorage energyStorage;
    private EnergyTransferMode mode = EnergyTransferMode.BOTH;

    public EnergyManager(int maxTransfer, int capacity) {
        this.energyStorage = new EnergyStorage(EnergyManager.scaleForDifficulty(capacity), EnergyManager.scaleForDifficulty(maxTransfer), EnergyManager.scaleForDifficulty(maxTransfer));
    }

    public static int scaleForDifficulty(int energyPerUse) {
        return Math.round((float)energyPerUse * ForestryAPI.activeMode.getFloatSetting("energy.demand.modifier"));
    }

    public void setExtractOnly() {
        this.mode = EnergyTransferMode.EXTRACT;
    }

    public void setReceiveOnly() {
        this.mode = EnergyTransferMode.RECEIVE;
    }

    private boolean canExtract() {
        switch (this.mode) {
            case EXTRACT: 
            case BOTH: {
                return true;
            }
        }
        return false;
    }

    private boolean canReceive() {
        switch (this.mode) {
            case BOTH: 
            case RECEIVE: {
                return true;
            }
        }
        return false;
    }

    public EnergyManager readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound energyManagerNBT = nbt.func_74775_l("EnergyManager");
        NBTTagCompound energyStorageNBT = energyManagerNBT.func_74775_l("EnergyStorage");
        this.energyStorage.readFromNBT(energyStorageNBT);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound energyStorageNBT = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyStorageNBT);
        NBTTagCompound energyManagerNBT = new NBTTagCompound();
        energyManagerNBT.func_74782_a("EnergyStorage", (NBTBase)energyStorageNBT);
        nbt.func_74782_a("EnergyManager", (NBTBase)energyManagerNBT);
        return nbt;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        int energyStored = this.energyStorage.getEnergyStored();
        data.writeInt(energyStored);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        int energyStored = data.readInt();
        this.energyStorage.setEnergyStored(energyStored);
    }

    public int toGuiInt() {
        return this.energyStorage.getEnergyStored();
    }

    public void fromGuiInt(int packetInt) {
        this.energyStorage.setEnergyStored(packetInt);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getTotalEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getMaxEnergyReceived() {
        return this.energyStorage.getMaxReceive();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public boolean consumeEnergyToDoWork(int ticksPerWorkCycle, int energyPerWorkCycle) {
        int energyPerCycle = (int)Math.ceil((float)energyPerWorkCycle / (float)ticksPerWorkCycle);
        if (this.energyStorage.getEnergyStored() < energyPerCycle) {
            return false;
        }
        this.energyStorage.modifyEnergyStored(-energyPerCycle);
        return true;
    }

    public boolean canSendEnergy(ForgeDirection orientation, TileEntity tile) {
        return this.sendEnergy(orientation, tile, Integer.MAX_VALUE, true) > 0;
    }

    public int sendEnergy(ForgeDirection orientation, TileEntity tile) {
        return this.sendEnergy(orientation, tile, Integer.MAX_VALUE, false);
    }

    public int sendEnergy(ForgeDirection orientation, TileEntity tile, int amount, boolean simulate) {
        int extractable;
        int sent = 0;
        if (BlockUtil.isEnergyReceiverOrEngine(orientation.getOpposite(), tile) && (extractable = this.energyStorage.extractEnergy(amount, true)) > 0) {
            if (tile instanceof IEnergyReceiver) {
                IEnergyReceiver receptor = (IEnergyReceiver)tile;
                sent = receptor.receiveEnergy(orientation.getOpposite(), extractable, simulate);
            } else if (tile instanceof TileEngine) {
                TileEngine receptor = (TileEngine)tile;
                sent = receptor.getEnergyManager().receiveEnergy(orientation.getOpposite(), extractable, simulate);
            }
            this.energyStorage.extractEnergy(sent, simulate);
        }
        return sent;
    }

    public void drainEnergy(int amount) {
        this.energyStorage.modifyEnergyStored(-amount);
    }

    public void generateEnergy(int amount) {
        this.energyStorage.modifyEnergyStored(amount);
    }

    private static enum EnergyTransferMode {
        EXTRACT,
        RECEIVE,
        BOTH;

    }
}

