/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.FarmLogicWatered;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class FarmLogicCrops
extends FarmLogicWatered {
    private static final ItemStack farmland = new ItemStack(Blocks.field_150458_ak, 1, Short.MAX_VALUE);
    private final Iterable<IFarmable> seeds;

    protected FarmLogicCrops(IFarmHousing housing, Iterable<IFarmable> seeds) {
        super(housing, new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150458_ak));
        this.seeds = seeds;
    }

    @Override
    public boolean isAcceptedGround(ItemStack itemStack) {
        return super.isAcceptedGround(itemStack) || ItemStackUtil.isIdenticalItem(farmland, itemStack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        List products = this.produce;
        this.produce = this.collectEntityItems(false);
        return products;
    }

    @Override
    protected boolean maintainCrops(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!VectUtil.isAirBlock(world, position) && !BlockUtil.isReplaceableBlock(this.getWorld(), position.x, position.y, position.z)) continue;
            ItemStack below = VectUtil.getAsItemStack(world, position.add(0, -1, 0));
            if (this.ground.func_77973_b() != below.func_77973_b() || below.func_77960_j() <= 0) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(IVect position) {
        World world = this.getWorld();
        for (IFarmable candidate : this.seeds) {
            if (!this.housing.plantGermling(candidate, world, position.getX(), position.getY(), position.getZ())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        ArrayDeque<ICrop> crops = new ArrayDeque<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

