/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.config;

import appeng.util.Platform;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public enum FuzzyMode {
    IGNORE_ALL(-1.0f),
    PERCENT_99(0.0f),
    PERCENT_75(25.0f),
    PERCENT_50(50.0f),
    PERCENT_25(75.0f);

    public final float breakPoint;
    public final float percentage;

    private FuzzyMode(float p) {
        this.percentage = p;
        this.breakPoint = p / 100.0f;
    }

    public int calculateBreakPoint(int maxDamage) {
        return (int)(this.percentage * (float)maxDamage / 100.0f);
    }

    @Nonnull
    public static FuzzyMode fromItemStack(@Nonnull ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        if (fz == null || fz.isEmpty()) {
            return IGNORE_ALL;
        }
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (IllegalArgumentException ignored) {
            return IGNORE_ALL;
        }
    }
}

