/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import goodgenerator.blocks.structures.AntimatterStructures;
import goodgenerator.blocks.tileEntity.AntimatterOutputHatch;
import goodgenerator.blocks.tileEntity.render.TileAntimatter;
import goodgenerator.items.GGMaterial;
import goodgenerator.loader.Loaders;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.ExoticEnergyInputHelper;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.IDualInputHatch;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class AntimatterForge
extends MTEExtendedPowerMultiBlockBase<AntimatterForge>
implements ISurvivalConstructable,
IOverclockDescriptionProvider {
    private static final FluidStack[] magneticUpgrades = new FluidStack[]{Materials.TengamAttuned.getMolten(1L), MaterialsUEVplus.Time.getMolten(1L)};
    private static final FluidStack[] gravityUpgrades = new FluidStack[]{MaterialsUEVplus.SpaceTime.getMolten(1L), MaterialsUEVplus.Space.getMolten(1L), MaterialsUEVplus.Eternity.getMolten(1L)};
    private static final FluidStack[] containmentUpgrades = new FluidStack[]{GGMaterial.shirabon.getMolten(1), MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(1L)};
    private static final FluidStack[] activationUpgrades = new FluidStack[]{GGMaterial.naquadahBasedFuelMkVDepleted.getFluidOrGas(1), GGMaterial.naquadahBasedFuelMkVIDepleted.getFluidOrGas(1)};
    private static final int MAGNETIC_ID = 0;
    private static final int GRAVITY_ID = 1;
    private static final int CONTAINMENT_ID = 2;
    private static final int ACTIVATION_ID = 3;
    private static final int BASE_CONSUMPTION = 10000000;
    private static final int passiveBaseMult = 1000;
    private static final int activeBaseMult = 10000;
    private static final float passiveBaseExp = 1.5f;
    private static final float activeBaseExp = 1.5f;
    private static final float coefficientBaseExp = 0.5f;
    private static final float baseSkew = 0.2f;
    private final float[] modifiers = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final FluidStack[] upgradeFluids = new FluidStack[]{null, null, null, null};
    private final int[] fluidConsumptions = new int[]{0, 0, 0, 0};
    public static final String MAIN_NAME = "antimatterForge";
    private final int speed = 20;
    private long rollingCost = 0L;
    private boolean isLoadedChunk;
    public GTRecipe mLastRecipe;
    public int para;
    private final Random r = new Random();
    private long guiAntimatterAmount = 0L;
    private long guiAntimatterChange = 0L;
    private long guiPassiveEnergy = 0L;
    private long guiActiveEnergy = 0L;
    private final boolean canRender = false;
    private final List<AntimatterOutputHatch> amOutputHatches = new ArrayList<AntimatterOutputHatch>(16);
    private static final ClassValue<IStructureDefinition<AntimatterForge>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<AntimatterForge>>(){

        @Override
        protected IStructureDefinition<AntimatterForge> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(AntimatterForge.MAIN_NAME, AntimatterStructures.ANTIMATTER_FORGE).addElement('A', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getFrameBlock(), (int)x.getFrameMeta()))).addElement('B', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCoilBlock(), (int)x.getCoilMeta()))).addElement('C', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCasingBlock(2), (int)x.getCasingMeta(2)))).addElement('D', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCasingBlock(1), (int)x.getCasingMeta(1)))).addElement('F', (IStructureElement)StructureUtility.lazy(x -> HatchElementBuilder.builder().anyOf(HatchElement.InputHatch).adder((rec$, x$0, x$1) -> ((AntimatterForge)rec$).addFluidIO(x$0, x$1)).casingIndex(x.textureIndex(2)).dot(1).buildAndChain(x.getCasingBlock(2), x.getCasingMeta(2)))).addElement('E', (IStructureElement)StructureUtility.lazy(x -> GTStructureUtility.buildHatchAdder(AntimatterForge.class).adder((rec$, x$0, x$1) -> ((AntimatterForge)rec$).addAntimatterHatch(x$0, x$1)).hatchClass(AntimatterOutputHatch.class).casingIndex(x.textureIndex(1)).dot(3).build())).addElement('H', (IStructureElement)StructureUtility.lazy(x -> HatchElementBuilder.builder().anyOf(HatchElement.Energy.or(HatchElement.ExoticEnergy)).adder((rec$, x$0, x$1) -> ((AntimatterForge)rec$).addEnergyInjector(x$0, x$1)).casingIndex(x.textureIndex(2)).dot(2).buildAndChain(x.getCasingBlock(2), x.getCasingMeta(2)))).build();
        }
    };
    private static final ITexture textureOverlay;
    protected long antimatterAmountCache;
    protected long passiveCostCache;
    protected long activeCostCache;
    protected long antimatterChangeCache;
    protected static final NumberFormatMUI numberFormat;
    protected static DecimalFormat standardFormat;

    public AntimatterForge(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public AntimatterForge(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new AntimatterForge(MAIN_NAME);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Antimatter Forge").addInfo(EnumChatFormatting.LIGHT_PURPLE + "Dimensions not included!" + EnumChatFormatting.GRAY).addInfo("Converts protomatter into antimatter").addInfo("Consumes 10 000 000 + (" + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + " * " + 1000 + ")^" + EnumChatFormatting.GREEN + 1.5f + EnumChatFormatting.GRAY + " EU/t passively. The consumption decays by 0.5% every tick when empty").addInfo("Uses (" + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + " * " + 10000 + ")^" + EnumChatFormatting.DARK_PURPLE + 1.5f + EnumChatFormatting.GRAY + " EU per operation to produce antimatter").addSeparator().addInfo("Every cycle, the lowest amount of antimatter in the 16 antimatter hatches is recorded").addInfo("Cycles every 5 seconds").addInfo("All hatches with more than the lowest amount will " + EnumChatFormatting.RED + "lose half the difference!" + EnumChatFormatting.GRAY).addInfo("If the machine runs out of energy or protomatter during a cycle, " + EnumChatFormatting.RED + "10% of antimatter will be voided!" + EnumChatFormatting.GRAY).addInfo("Produces (" + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + "^" + EnumChatFormatting.GOLD + 0.5f + EnumChatFormatting.GRAY + ") * N(" + EnumChatFormatting.AQUA + 0.2f + EnumChatFormatting.GRAY + ", 0.25) of antimatter per cycle, consuming equal amounts of Protomatter").addInfo("The change is split between the 16 Antimatter Hatches, sampled from N(" + EnumChatFormatting.AQUA + 0.2f + EnumChatFormatting.GRAY + ", 1) (Gaussian distribution with mean of " + 0.2f + ")").addInfo("The total change can be negative!").addSeparator().addInfo("Can be supplied with stabilization fluids to improve antimatter generation").addInfo(EnumChatFormatting.GREEN + "Magnetic Stabilization" + EnumChatFormatting.GRAY + " (Uses " + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + "^0.5 per cycle)").addInfo("1. Molten Purified Tengam - Passive cost exponent " + EnumChatFormatting.GREEN + "-0.15" + EnumChatFormatting.GRAY).addInfo("2. Tachyon Rich Fluid - Passive cost exponent " + EnumChatFormatting.GREEN + "-0.3" + EnumChatFormatting.GRAY).addInfo(EnumChatFormatting.DARK_PURPLE + "Gravity Stabilization" + EnumChatFormatting.GRAY + " (Uses " + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + "^0.5 per cycle)").addInfo("1. Molten Spacetime - Active cost exponent " + EnumChatFormatting.DARK_PURPLE + "-0.05" + EnumChatFormatting.GRAY).addInfo("2. Spatially Enlarged Fluid - Active cost exponent " + EnumChatFormatting.DARK_PURPLE + "-0.10" + EnumChatFormatting.GRAY).addInfo("3. Molten Eternity - Active cost exponent " + EnumChatFormatting.DARK_PURPLE + "-0.15" + EnumChatFormatting.GRAY).addInfo(EnumChatFormatting.GOLD + "Containment Stabilization" + EnumChatFormatting.GRAY + " (Uses " + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + "^(2/7) per operation)").addInfo("1. Molten Shirabon - Production exponent " + EnumChatFormatting.GOLD + "+0.05" + EnumChatFormatting.GRAY).addInfo("2. Molten MHDCSM - Production exponent " + EnumChatFormatting.GOLD + "+0.10" + EnumChatFormatting.GRAY).addInfo(EnumChatFormatting.AQUA + "Activation Stabilization" + EnumChatFormatting.GRAY + " (Uses " + EnumChatFormatting.DARK_AQUA + "Antimatter" + EnumChatFormatting.GRAY + "^(1/3) per operation)").addInfo("1. Depleted Naquadah Fuel Mk V - Distribution skew " + EnumChatFormatting.AQUA + "+0.05" + EnumChatFormatting.GRAY).addInfo("2. Depleted Naquadah Fuel Mk VI - Distribution skew " + EnumChatFormatting.AQUA + "+0.10" + EnumChatFormatting.GRAY).addInfo("Each stabilization can only use one of the fluids at a time").addCasingInfoMin("Antimatter Containment Casing", 512, false).addCasingInfoMin("Magnetic Flux Casing", 2274, false).addCasingInfoMin("Gravity Stabilization Casing", 623, false).addCasingInfoMin("Protomatter Activation Coil", 126, false).addInputHatch("1-6, Hint block with dot 1", 1).addEnergyHatch("1-9, Hint block with dot 2", 2).addOtherStructurePart("Antimatter Hatch", "16, Hint Block with dot 3", 3).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<AntimatterForge> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    public Block getCasingBlock(int type) {
        switch (type) {
            case 1: {
                return Loaders.magneticFluxCasing;
            }
            case 2: {
                return Loaders.gravityStabilizationCasing;
            }
        }
        return Loaders.magneticFluxCasing;
    }

    public int getCasingMeta(int type) {
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public Block getCoilBlock() {
        return Loaders.protomatterActivationCoil;
    }

    public int getCoilMeta() {
        return 0;
    }

    public Block getFrameBlock() {
        return Loaders.antimatterContainmentCasing;
    }

    public int getFrameMeta() {
        return 0;
    }

    public int textureIndex(int type) {
        switch (type) {
            case 1: {
                return 1545;
            }
            case 2: {
                return 1546;
            }
        }
        return 1545;
    }

    public ITexture getTextureOverlay() {
        return textureOverlay;
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GTItemStack aStack) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(MAIN_NAME, 26, 26, 4);
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(MAIN_NAME, itemStack, b, 26, 26, 4);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(MAIN_NAME, stackSize, 26, 26, 4, realBudget, env, false, true);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER).extFacing().build(), this.getTextureOverlay()};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(53)};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER).extFacing().build()};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdate = 100;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            FluidStack[] antimatterStored = new FluidStack[16];
            long totalAntimatterAmount = 0L;
            for (int i = 0; i < this.amOutputHatches.size(); ++i) {
                if (this.amOutputHatches.get(i) == null || !this.amOutputHatches.get(i).isValid() || this.amOutputHatches.get(i).getFluid() == null) continue;
                antimatterStored[i] = this.amOutputHatches.get(i).getFluid().copy();
                totalAntimatterAmount += (long)antimatterStored[i].amount;
            }
            this.drainEnergyInput(this.calculateEnergyContainmentCost(totalAntimatterAmount));
            if (this.mProgresstime >= this.mMaxProgresstime && !this.isAllowedToWork()) {
                this.setProtoRender(false);
            }
        }
    }

    private long calculateContainedAntimatter() {
        long antimatterStored = 0L;
        for (AntimatterOutputHatch amOutputHatch : this.amOutputHatches) {
            if (amOutputHatch == null || !amOutputHatch.isValid() || amOutputHatch.getFluid() == null) continue;
            antimatterStored += (long)amOutputHatch.getFluid().amount;
        }
        return antimatterStored;
    }

    private void setModifiers(FluidStack inputFluid, float step, FluidStack[] fluidArray, int upgradeId) {
        for (int tier = 1; tier <= fluidArray.length; ++tier) {
            if (!inputFluid.isFluidEqual(fluidArray[tier - 1]) || inputFluid.amount < this.fluidConsumptions[upgradeId]) continue;
            this.modifiers[upgradeId] = step * (float)tier;
            this.upgradeFluids[upgradeId] = inputFluid;
        }
    }

    @Override
    public CheckRecipeResult checkProcessing() {
        this.startRecipeProcessing();
        FluidStack[] antimatterStored = new FluidStack[16];
        long totalAntimatterAmount = 0L;
        long minAntimatterAmount = Long.MAX_VALUE;
        for (int i = 0; i < this.amOutputHatches.size(); ++i) {
            if (this.amOutputHatches.get(i) == null || !this.amOutputHatches.get(i).isValid() || this.amOutputHatches.get(i).getFluid() == null) continue;
            antimatterStored[i] = this.amOutputHatches.get(i).getFluid().copy();
            totalAntimatterAmount += (long)antimatterStored[i].amount;
            minAntimatterAmount = Math.min(minAntimatterAmount, (long)antimatterStored[i].amount);
        }
        int ratioLosses = 0;
        for (AntimatterOutputHatch amOutputHatch : this.amOutputHatches) {
            if (amOutputHatch == null || !amOutputHatch.isValid() || amOutputHatch.getFluid() == null) continue;
            FluidStack fluid = amOutputHatch.getFluid().copy();
            ratioLosses -= amOutputHatch.drain((int)((int)((double)((long)fluid.amount - minAntimatterAmount) * 0.5)), (boolean)true).amount;
        }
        long containedProtomatter = 0L;
        this.fluidConsumptions[0] = (int)Math.ceil(Math.pow(totalAntimatterAmount, 0.5));
        this.fluidConsumptions[1] = (int)Math.ceil(Math.pow(totalAntimatterAmount, 0.5));
        this.fluidConsumptions[2] = (int)Math.ceil(Math.pow(totalAntimatterAmount, 0.2857142984867096));
        this.fluidConsumptions[3] = (int)Math.ceil(Math.pow(totalAntimatterAmount, 0.3333333432674408));
        for (int i = 0; i < this.modifiers.length; ++i) {
            this.modifiers[i] = 0.0f;
            this.upgradeFluids[i] = null;
        }
        ArrayList<FluidStack> inputFluids = this.getStoredFluids();
        for (FluidStack inputFluid : inputFluids) {
            this.setModifiers(inputFluid, -0.15f, magneticUpgrades, 0);
            this.setModifiers(inputFluid, -0.05f, gravityUpgrades, 1);
            this.setModifiers(inputFluid, 0.05f, containmentUpgrades, 2);
            this.setModifiers(inputFluid, 0.05f, activationUpgrades, 3);
        }
        long energyCost = this.calculateEnergyCost(totalAntimatterAmount);
        if (!this.drainEnergyInput(energyCost)) {
            this.decimateAntimatter();
            this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
            this.endRecipeProcessing();
            this.setProtoRender(false);
            return CheckRecipeResultRegistry.insufficientPower(energyCost);
        }
        for (int i = 0; i < this.upgradeFluids.length; ++i) {
            FluidStack upgradeFluid = this.upgradeFluids[i];
            if (upgradeFluid == null) continue;
            for (FluidStack inputFluid : inputFluids.toArray(new FluidStack[0])) {
                if (!inputFluid.isFluidEqual(upgradeFluid)) continue;
                inputFluid.amount -= this.fluidConsumptions[i];
            }
        }
        int antimatterChange = this.distributeAntimatterToHatch(this.amOutputHatches, totalAntimatterAmount, containedProtomatter);
        if (!this.depleteInput(MaterialsUEVplus.Protomatter.getFluid(Math.abs(antimatterChange)))) {
            this.decimateAntimatter();
            this.stopMachine(ShutDownReasonRegistry.outOfFluid(MaterialsUEVplus.Protomatter.getFluid(1L)));
            this.endRecipeProcessing();
            this.setProtoRender(false);
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
        this.guiAntimatterChange = ratioLosses + antimatterChange;
        this.guiAntimatterAmount = this.calculateContainedAntimatter();
        this.updateAntimatterSize(this.guiAntimatterAmount);
        this.setProtoRender(true);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        this.endRecipeProcessing();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private long calculateEnergyContainmentCost(long antimatterAmount) {
        long value;
        if (antimatterAmount == 0L) {
            this.rollingCost = (long)((double)this.rollingCost * 0.995);
            if (this.rollingCost < 100L) {
                this.rollingCost = 0L;
            }
        } else {
            this.rollingCost = this.rollingCost < antimatterAmount * 1000L ? (this.rollingCost += antimatterAmount) : (long)((double)this.rollingCost * 0.995);
        }
        this.guiPassiveEnergy = value = 10000000L + (long)Math.pow(this.rollingCost, 1.5 + (double)this.modifiers[0]);
        return value;
    }

    private long calculateEnergyCost(long antimatterAmount) {
        long value;
        this.guiActiveEnergy = value = (long)Math.pow(antimatterAmount * 10000L, 1.5f + this.modifiers[1]);
        return value;
    }

    private void decimateAntimatter() {
        for (AntimatterOutputHatch amOutputHatch : this.amOutputHatches) {
            if (amOutputHatch == null || !amOutputHatch.isValid() || amOutputHatch.getFluid() == null) continue;
            FluidStack fluid = amOutputHatch.getFluid().copy();
            amOutputHatch.drain((int)Math.floor((double)fluid.amount * 0.1), true);
        }
    }

    private int distributeAntimatterToHatch(List<AntimatterOutputHatch> hatches, long totalAntimatterAmount, long protomatterAmount) {
        double coeff = Math.pow(totalAntimatterAmount, 0.5 + (double)this.modifiers[2]);
        int difference = 0;
        for (AntimatterOutputHatch hatch : hatches) {
            int change = (int)Math.ceil((this.r.nextGaussian() + (double)0.2f + (double)this.modifiers[3]) * (coeff / 16.0));
            difference += change;
            if (change >= 0) {
                hatch.fill(MaterialsUEVplus.Antimatter.getFluid(change), true);
                continue;
            }
            hatch.drain(-change, true);
        }
        return difference;
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.amOutputHatches.clear();
    }

    @Override
    public void onRemoval() {
        if (this.isLoadedChunk) {
            GTChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
        }
        super.onRemoval();
    }

    public int getChunkX() {
        return this.getBaseMetaTileEntity().getXCoord() >> 4;
    }

    public int getChunkZ() {
        return this.getBaseMetaTileEntity().getZCoord() >> 4;
    }

    private boolean addEnergyInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            MTEHatch hatch = (MTEHatch)aMetaTileEntity;
            if (ExoticEnergyInputHelper.isExoticEnergyInput(aMetaTileEntity)) {
                hatch.updateTexture(aBaseCasingIndex);
                hatch.updateCraftingIcon(this.getMachineCraftingIcon());
                return this.mExoticEnergyHatches.add(hatch);
            }
        }
        return false;
    }

    private boolean addFluidIO(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        Object tInput;
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            MTEHatch hatch = (MTEHatch)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            tInput = (MTEHatchInput)aMetaTileEntity;
            ((MTEHatchInput)tInput).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tInput);
        }
        if (aMetaTileEntity instanceof AntimatterOutputHatch) {
            AntimatterOutputHatch tAntimatter = (AntimatterOutputHatch)aMetaTileEntity;
            return this.amOutputHatches.add(tAntimatter);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            MTEHatchOutput tOutput = (MTEHatchOutput)aMetaTileEntity;
            return this.mOutputHatches.add(tOutput);
        }
        if (aMetaTileEntity instanceof IDualInputHatch) {
            tInput = (IDualInputHatch)((Object)aMetaTileEntity);
            tInput.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mDualInputHatches.add(tInput);
        }
        return false;
    }

    private boolean addAntimatterHatch(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            MTEHatch hatch = (MTEHatch)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
        }
        if (aMetaTileEntity instanceof AntimatterOutputHatch) {
            AntimatterOutputHatch tAntimatter = (AntimatterOutputHatch)aMetaTileEntity;
            return this.amOutputHatches.add(tAntimatter);
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public OverclockDescriber getOverclockDescriber() {
        return null;
    }

    @Override
    public String[] getInfoData() {
        IGregTechTileEntity baseMetaTileEntity = this.getBaseMetaTileEntity();
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatch tHatch : this.mExoticEnergyHatches) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{EnumChatFormatting.BLUE + "Antimatter Forge " + EnumChatFormatting.GRAY, StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime) + EnumChatFormatting.RESET + "t / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime) + EnumChatFormatting.RESET + "t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"gui.AntimatterForge.0") + ": " + EnumChatFormatting.BLUE + GTUtility.formatNumbers(this.guiAntimatterAmount) + EnumChatFormatting.RESET + " L", StatCollector.func_74838_a((String)"gui.AntimatterForge.1") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.guiPassiveEnergy) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"gui.AntimatterForge.2") + ": " + EnumChatFormatting.LIGHT_PURPLE + GTUtility.formatNumbers(this.guiActiveEnergy) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"gui.AntimatterForge.3") + ": " + EnumChatFormatting.AQUA + GTUtility.formatNumbers(this.guiAntimatterChange) + EnumChatFormatting.RESET + " L"};
    }

    private long getAntimatterAmount() {
        return this.guiAntimatterAmount;
    }

    private long getPassiveConsumption() {
        return this.guiPassiveEnergy;
    }

    private long getActiveConsumption() {
        return this.guiActiveEnergy;
    }

    private long getAntimatterChange() {
        return this.guiAntimatterChange;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.AntimatterForge.0") + ": " + EnumChatFormatting.BLUE + numberFormat.format(this.antimatterAmountCache) + EnumChatFormatting.WHITE + " L").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(this::getAntimatterAmount, val -> {
            this.antimatterAmountCache = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.AntimatterForge.1") + ": " + EnumChatFormatting.RED + standardFormat.format(this.passiveCostCache) + EnumChatFormatting.WHITE + " EU/t").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(this::getPassiveConsumption, val -> {
            this.passiveCostCache = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.AntimatterForge.2") + ": " + EnumChatFormatting.LIGHT_PURPLE + standardFormat.format(this.activeCostCache) + EnumChatFormatting.WHITE + " EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(this::getActiveConsumption, val -> {
            this.activeCostCache = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.AntimatterForge.3") + ": " + EnumChatFormatting.AQUA + numberFormat.format(this.antimatterChangeCache) + EnumChatFormatting.WHITE + " L").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(this::getAntimatterChange, val -> {
            this.antimatterChangeCache = val;
        }));
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    @Override
    public void stopMachine(@Nonnull ShutDownReason reason) {
        super.stopMachine(reason);
        this.setProtoRender(false);
    }

    @Override
    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        this.destroyAntimatterRender();
    }

    public void updateAntimatterSize(float antimatterAmount) {
        if (antimatterAmount <= 0.0f) {
            this.destroyAntimatterRender();
            return;
        }
        TileAntimatter render = this.getAntimatterRender();
        if (render == null) {
            this.createAntimatterRender();
            render = this.getAntimatterRender();
        }
        float size = (float)Math.pow(antimatterAmount, 0.17);
        render.setCoreSize(size);
    }

    public void setProtoRender(boolean flag) {
        TileAntimatter render = this.getAntimatterRender();
        if (render == null) {
            return;
        }
        render.setProtomatterRender(flag);
        if (!flag) {
            return;
        }
        render.setRotationFields(this.getDirection(), this.getRotation());
    }

    public TileAntimatter getAntimatterRender() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        World world = gregTechTileEntity.getWorld();
        if (world == null) {
            return null;
        }
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        double xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        double zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        double yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int wX = (int)((double)x + xOffset);
        int wY = (int)((double)y + yOffset);
        int wZ = (int)((double)z + zOffset);
        return (TileAntimatter)world.func_147438_o(wX, wY, wZ);
    }

    public void destroyAntimatterRender() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        World world = gregTechTileEntity.getWorld();
        if (world == null) {
            return;
        }
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        int xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        int xTarget = x + xOffset;
        int yTarget = y + yOffset;
        int zTarget = z + zOffset;
        world.func_147449_b(xTarget, yTarget, zTarget, Blocks.field_150350_a);
    }

    public void createAntimatterRender() {
        IGregTechTileEntity gregTechTileEntity = this.getBaseMetaTileEntity();
        World world = gregTechTileEntity.getWorld();
        if (world == null) {
            return;
        }
        int x = gregTechTileEntity.getXCoord();
        short y = gregTechTileEntity.getYCoord();
        int z = gregTechTileEntity.getZCoord();
        int xOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int yOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int zOffset = 16 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        int wX = x + xOffset;
        int wY = y + yOffset;
        int wZ = z + zOffset;
        world.func_147449_b(wX, wY, wZ, Blocks.field_150350_a);
        world.func_147449_b(wX, wY, wZ, Loaders.antimatterRenderBlock);
    }

    static {
        Textures.BlockIcons.setCasingTextureForId(53, TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_ANTIMATTER_GLOW).extFacing().glow().build()));
        textureOverlay = TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION1).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build());
        numberFormat = new NumberFormatMUI();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        dfs.setExponentSeparator("e");
        standardFormat = new DecimalFormat("0.00E0", dfs);
    }
}

