/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.blockupdate;

public class Cooldown {
    private long lastTimeStarted;
    protected int lengthInTicks;

    public Cooldown(int aLengthInTicks) {
        if (aLengthInTicks <= 0) {
            throw new IllegalArgumentException("length should be a positive non-zero number");
        }
        this.lengthInTicks = aLengthInTicks;
        this.lastTimeStarted = 0L;
    }

    public void set(long currTickTime) {
        this.lastTimeStarted = currTickTime;
    }

    public boolean hasPassed(long currTickTime) {
        return currTickTime - this.lastTimeStarted >= (long)this.lengthInTicks;
    }

    public long getLastTimeStarted() {
        return this.lastTimeStarted;
    }
}

