/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.ITextureBuilder;
import gregtech.common.render.GTTextureBuilder;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public final class TextureFactory {
    private TextureFactory() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static ITexture of(ITexture ... textures) {
        return TextureFactory.builder().addLayer(textures).build();
    }

    public static ITexture of(IIconContainer bottom, IIconContainer top, IIconContainer north, IIconContainer south, IIconContainer west, IIconContainer east, short[] rgba) {
        return TextureFactory.builder().addIcon(bottom, top, north, south, west, east).setRGBA(rgba).setAllowAlpha(true).build();
    }

    public static ITexture of(IIconContainer bottom, IIconContainer top, IIconContainer sides, short[] rgba) {
        return TextureFactory.builder().addIcon(bottom, top, sides, sides, sides, sides).setRGBA(rgba).setAllowAlpha(true).build();
    }

    public static ITexture of(IIconContainer iconContainer, short[] rgba, boolean allowAlpha) {
        return TextureFactory.builder().addIcon(iconContainer).setRGBA(rgba).setAllowAlpha(allowAlpha).build();
    }

    public static ITexture of(IIconContainer iconContainer, short[] rgba) {
        return TextureFactory.builder().addIcon(iconContainer).setRGBA(rgba).build();
    }

    public static ITexture of(IIconContainer iconContainer) {
        return TextureFactory.builder().addIcon(iconContainer).build();
    }

    public static ITexture of(Block block, int meta, ForgeDirection side, short[] rgba) {
        return TextureFactory.builder().setFromBlock(block, meta).setFromSide(side).setRGBA(rgba).build();
    }

    public static ITexture of(Block block, int meta, ForgeDirection side) {
        return TextureFactory.builder().setFromBlock(block, meta).setFromSide(side).build();
    }

    public static ITexture of(Block block, int meta) {
        return TextureFactory.builder().setFromBlock(block, meta).build();
    }

    public static ITexture of(Block block) {
        return TextureFactory.of(block, 0);
    }

    public static ITextureBuilder builder() {
        return new GTTextureBuilder();
    }
}

