/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.threads;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.tileentity.IMachineBlockUpdateable;
import gregtech.common.GTProxy;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RunnableMachineUpdate
implements Runnable {
    protected final int initialX;
    protected final int initialY;
    protected final int initialZ;
    protected final World world;
    protected final LongSet visited = new LongOpenHashSet();
    protected final LongArrayFIFOQueue tQueue = new LongArrayFIFOQueue();
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread thread = new Thread(r);
        thread.setName("GT_MachineBlockUpdate");
        return thread;
    };
    protected static ExecutorService EXECUTOR_SERVICE;
    protected static boolean isEnabled;
    protected static final ThreadLocal<Boolean> perThreadEnable;

    protected RunnableMachineUpdate(World aWorld, int posX, int posY, int posZ) {
        this.world = aWorld;
        this.initialX = posX;
        this.initialY = posY;
        this.initialZ = posZ;
        long coords = CoordinatePacker.pack((int)posX, (int)posY, (int)posZ);
        this.visited.add(coords);
        this.tQueue.enqueue(coords);
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled() {
        isEnabled = true;
    }

    public static void setDisabled() {
        isEnabled = false;
    }

    public static void setEnabled(boolean isEnabled) {
        RunnableMachineUpdate.isEnabled = isEnabled;
    }

    public static boolean isCurrentThreadEnabled() {
        return perThreadEnable.get();
    }

    public static void setCurrentThreadEnabled(boolean perThreadEnable) {
        RunnableMachineUpdate.perThreadEnable.set(perThreadEnable);
    }

    public static void setMachineUpdateValues(World aWorld, int posX, int posY, int posZ) {
        if (RunnableMachineUpdate.isEnabled() && RunnableMachineUpdate.isCurrentThreadEnabled()) {
            EXECUTOR_SERVICE.submit(new RunnableMachineUpdate(aWorld, posX, posY, posZ));
        }
    }

    public static void initExecutorService() {
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() * 2 / 3), THREAD_FACTORY);
    }

    public static void shutdownExecutorService() {
        try {
            GTMod.GT_FML_LOGGER.info("Shutting down Machine block update executor service");
            EXECUTOR_SERVICE.shutdown();
            if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                EXECUTOR_SERVICE.shutdownNow();
                if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                    GTMod.GT_FML_LOGGER.error("Well this didn't terminated well... RunnableMachineUpdate.shutdownExecutorService");
                }
            }
        }
        catch (InterruptedException ie) {
            GTMod.GT_FML_LOGGER.error("Well this interruption got interrupted...", (Throwable)ie);
            EXECUTOR_SERVICE.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            GTMod.GT_FML_LOGGER.error("Well this didn't terminated well...", (Throwable)e);
            EXECUTOR_SERVICE.shutdownNow();
        }
        finally {
            GTMod.GT_FML_LOGGER.info("Leaving... RunnableMachineUpdate.shutdownExecutorService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.tQueue.isEmpty()) {
                boolean isMachineBlock;
                TileEntity tTileEntity;
                long packedCoords = this.tQueue.dequeueLong();
                int posX = CoordinatePacker.unpackX((long)packedCoords);
                int posY = CoordinatePacker.unpackY((long)packedCoords);
                int posZ = CoordinatePacker.unpackZ((long)packedCoords);
                GTProxy.TICK_LOCK.lock();
                try {
                    tTileEntity = this.world.func_147438_o(posX, posY, posZ);
                    isMachineBlock = GregTechAPI.isMachineBlock(this.world.func_147439_a(posX, posY, posZ), this.world.func_72805_g(posX, posY, posZ));
                }
                finally {
                    GTProxy.TICK_LOCK.unlock();
                }
                if (tTileEntity instanceof IMachineBlockUpdateable) {
                    ((IMachineBlockUpdateable)tTileEntity).onMachineBlockUpdate();
                }
                if (this.visited.size() >= 5 && (!(tTileEntity instanceof IMachineBlockUpdateable) || !((IMachineBlockUpdateable)tTileEntity).isMachineBlockUpdateRecursive()) && !isMachineBlock) continue;
                for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
                    ForgeDirection side = ForgeDirection.VALID_DIRECTIONS[i];
                    long tCoords = CoordinatePacker.pack((int)(posX + side.offsetX), (int)(posY + side.offsetY), (int)(posZ + side.offsetZ));
                    if (!this.visited.add(tCoords)) continue;
                    this.tQueue.enqueue(tCoords);
                }
            }
        }
        catch (Exception e) {
            GTMod.GT_FML_LOGGER.error("Well this update was broken... " + this.initialX + ", " + this.initialY + ", " + this.initialZ + ", mWorld={" + this.world.func_72827_u() + " @dimId " + this.world.field_73011_w.field_76574_g + "}", (Throwable)e);
        }
    }

    static {
        isEnabled = true;
        perThreadEnable = ThreadLocal.withInitial(() -> true);
    }
}

