/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.metadata.CompressionTierKey;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.GTProxy;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ProcessingPlate
implements IOreRecipeRegistrator {
    final CompressionTierKey COMPRESSION_TIER = CompressionTierKey.INSTANCE;

    public ProcessingPlate() {
        OrePrefixes.plate.add(this);
        OrePrefixes.plateDouble.add(this);
        OrePrefixes.plateTriple.add(this);
        OrePrefixes.plateQuadruple.add(this);
        OrePrefixes.plateQuintuple.add(this);
        OrePrefixes.plateDense.add(this);
        OrePrefixes.plateSuperdense.add(this);
        OrePrefixes.plateAlloy.add(this);
        OrePrefixes.itemCasing.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aNoWorking = aMaterial.contains(SubTag.NO_WORKING);
        long aMaterialMass = aMaterial.getMass();
        switch (aPrefix) {
            case plate: {
                this.registerPlate(aMaterial, aStack, aNoSmashing);
                break;
            }
            case plateDouble: {
                this.registerPlateDouble(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateTriple: {
                this.registerPlateTriple(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateQuadruple: {
                this.registerPlateQuadruple(aMaterial, aStack, aNoSmashing, aMaterialMass, aNoWorking);
                break;
            }
            case plateQuintuple: {
                this.registerPlateQuintuple(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateDense: {
                this.registerPlateDense(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateSuperdense: {
                this.registerPlateSuperdense(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case itemCasing: {
                this.registerItemCasing(aPrefix, aMaterial, aStack, aNoSmashing);
                break;
            }
            case plateAlloy: {
                this.registerPlateAlloy(aOreDictName, aStack);
                break;
            }
        }
    }

    private void registerPlate(Materials aMaterial, ItemStack aStack, boolean aNoSmashing) {
        this.registerCover(aMaterial, aStack);
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        GTModHandler.removeRecipeDelayed(aStack);
        GTUtility.removeSimpleIC2MachineRecipe(GTUtility.copyAmount(9, aStack), GTModHandler.getCompressorRecipeList(), GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L));
        if (aMaterial.mFuelPower > 0) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
        }
        if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Plate.get(0L, new Object[0])).itemOutputs(aMaterial.getPlates(1)).fluidInputs(aMaterial.getMolten(144L)).duration(32).eut(GTUtility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.foil, aMaterial, 2L), GTProxy.tBits, new Object[]{"hX", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
        if (aMaterial == Materials.Paper) {
            GTModHandler.addCraftingRecipe(GTUtility.copyAmount(2, aStack), GTModHandler.RecipeBits.BUFFERED, new Object[]{"XXX", Character.valueOf('X'), new ItemStack(Items.field_151120_aE, 1, Short.MAX_VALUE)});
        }
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
            if (!aNoSmashing && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                GTModHandler.addCraftingRecipe(aMaterial.getPlates(1), GTProxy.tBits, new Object[]{"h", "X", "X", Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                GTModHandler.addCraftingRecipe(aMaterial.getPlates(1), GTProxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                GTModHandler.addCraftingRecipe(aMaterial.getPlates(1), GTProxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                GTModHandler.addCraftingRecipe(aMaterial.getPlates(1), GTProxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
            }
            if (aMaterial.contains(SubTag.MORTAR_GRINDABLE) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                GTModHandler.addShapelessCraftingRecipe(aMaterial.getDust(1), GTProxy.tBits, new Object[]{ToolDictNames.craftingToolMortar, OrePrefixes.plate.get(aMaterial)});
            }
        }
    }

    private void registerPlateDouble(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            if (GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L) != null) {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
            }
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTUtility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTUtility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(10L)).duration(64).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                GTModHandler.addCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), aPlateStack, Character.valueOf('B'), aPlateStack});
            }
        }
    }

    private void registerPlateTriple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            if (GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L) != null) {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
            }
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTUtility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTUtility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(20L)).duration(96).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            GTModHandler.addCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateDouble.get(aMaterial), Character.valueOf('B'), aPlateStack});
            GTModHandler.addShapelessCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack});
        }
        if (GTOreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 2).addTo(RecipeMaps.implosionRecipes);
        }
    }

    private void registerPlateQuadruple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass, boolean aNoWorking) {
        this.registerCover(aMaterial, aStack);
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTUtility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 4L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTUtility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(30L)).duration(128).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            GTModHandler.addCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateTriple.get(aMaterial), Character.valueOf('B'), aPlateStack});
            GTModHandler.addShapelessCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
        }
    }

    private void registerPlateQuintuple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), GTUtility.getIntegratedCircuit(5)).itemOutputs(GTUtility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 5L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), GTUtility.getIntegratedCircuit(5)).itemOutputs(GTUtility.copyAmount(1, aStack)).fluidInputs(Materials.Glue.getFluid(40L)).duration(160).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (!aNoSmashing && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            Object aPlateStack = OrePrefixes.plate.get(aMaterial);
            GTModHandler.addCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateQuadruple.get(aMaterial), Character.valueOf('B'), aPlateStack});
            GTModHandler.addShapelessCraftingRecipe(GTUtility.copyAmount(1, aStack), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
        }
    }

    private void registerPlateDense(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 9L), GTUtility.getIntegratedCircuit(9)).itemOutputs(GTUtility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 9L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
        }
    }

    private void registerPlateSuperdense(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing || aMaterial.contains(SubTag.STRETCHY)) {
            int compression_tier = (long)aMaterial.processingMaterialTierEU >= TierEU.RECIPE_UEV || aMaterial.contains(SubTag.BLACK_HOLE) ? 2 : 1;
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 64L)).itemOutputs(GTUtility.copyAmount(1, aStack)).duration(Math.max(aMaterialMass * 32L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).metadata(this.COMPRESSION_TIER, compression_tier).addTo(RecipeMaps.compressorRecipes);
        }
    }

    private void registerItemCasing(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aNoSmashing) {
        GTModHandler.removeRecipeByOutputDelayed(aStack);
        if (aMaterial.mStandardMoltenFluid != null) {
            GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(72L)).duration(16).eut(GTUtility.calculateRecipeEU(aMaterial, 8)).addTo(RecipeMaps.fluidSolidifierRecipes);
        }
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aNoSmashing && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GTProxy.tBits, new Object[]{"h X", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GTProxy.tBits, new Object[]{"H X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
        }
        if (GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 2L), ItemList.Shape_Mold_Casing.get(0L, new Object[0])).itemOutputs(GTUtility.copyAmount(3, aStack)).duration(128).eut(GTUtility.calculateRecipeEU(aMaterial, 15)).recipeCategory(RecipeCategories.alloySmelterMolding).addTo(RecipeMaps.alloySmelterRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L), ItemList.Shape_Extruder_Casing.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 45)).addTo(RecipeMaps.extruderRecipes);
        }
        if (GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, (int)Math.max(aMaterial.getMass(), 1L) * GTUtility.calculateRecipeEU(aMaterial, 16) / 320)))).duration(2 * (int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.cutterRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).fluidInputs(GTModHandler.getDistilledWater(Math.max(3, Math.min(750, (int)Math.max(aMaterial.getMass(), 1L) * GTUtility.calculateRecipeEU(aMaterial, 16) / 426)))).duration(2 * (int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.cutterRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L)).fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, (int)Math.max(aMaterial.getMass(), 1L) * GTUtility.calculateRecipeEU(aMaterial, 16) / 1280)))).duration((int)Math.max(aMaterial.getMass(), 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.cutterRecipes);
        }
    }

    private void registerPlateAlloy(String aOreDictName, ItemStack aStack) {
        switch (aOreDictName) {
            case "plateAlloyCarbon": {
                GTValues.RA.stdBuilder().itemInputs(GTModHandler.getIC2Item("generator", 1L), GTUtility.copyAmount(4, aStack)).itemOutputs(GTModHandler.getIC2Item("windMill", 1L)).duration(6400).eut(8).addTo(RecipeMaps.assemblerRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), new ItemStack(Blocks.field_150359_w, 3, Short.MAX_VALUE)).itemOutputs(GTModHandler.getIC2Item("reinforcedGlass", 4L)).duration(400).eut(4).addTo(RecipeMaps.alloySmelterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), Materials.Glass.getDust(3)).itemOutputs(GTModHandler.getIC2Item("reinforcedGlass", 4L)).duration(400).eut(4).addTo(RecipeMaps.alloySmelterRecipes);
                break;
            }
            case "plateAlloyAdvanced": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), new ItemStack(Blocks.field_150359_w, 3, Short.MAX_VALUE)).itemOutputs(GTModHandler.getIC2Item("reinforcedGlass", 4L)).duration(400).eut(4).addTo(RecipeMaps.alloySmelterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), Materials.Glass.getDust(3)).itemOutputs(GTModHandler.getIC2Item("reinforcedGlass", 4L)).duration(400).eut(4).addTo(RecipeMaps.alloySmelterRecipes);
                break;
            }
            case "plateAlloyIridium": {
                GTModHandler.removeRecipeByOutputDelayed(aStack);
                break;
            }
        }
    }

    private void registerCover(Materials aMaterial, ItemStack aStack) {
        OrePrefixes orePrefix;
        ItemStack tStack = GTValues.NI;
        OrePrefixes[] orePrefixesArray = new OrePrefixes[]{OrePrefixes.block, OrePrefixes.block_, OrePrefixes.stoneSmooth, OrePrefixes.stone};
        int n = orePrefixesArray.length;
        for (int i = 0; i < n && (tStack = GTOreDictUnificator.get(orePrefix = orePrefixesArray[i], aMaterial, 1L)) == GTValues.NI; ++i) {
        }
        GregTechAPI.registerCover(aStack, tStack == GTValues.NI ? TextureFactory.builder().addIcon(aMaterial.mIconSet.mTextures[71]).setRGBA(aMaterial.mRGBa).stdOrient().build() : TextureFactory.of(Block.func_149634_a((Item)tStack.func_77973_b()), tStack.func_77960_j()), null);
    }
}

