/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.itemblock;

import gtPlusPlus.core.block.base.BlockBaseOre;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT_Ore_Layer;
import gtPlusPlus.everglades.gen.gt.WorldGen_Ores;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemBlockOre
extends ItemBlock {
    private final BlockBaseOre mThisOre;
    private final Material mThisMaterial;
    private final int mThisRadiation;
    private static final Map<String, HashSet<String>> mMapOreBlockItemToDimName = new LinkedHashMap<String, HashSet<String>>();
    private static boolean mInitOres_Everglades = false;
    private HashSet<String> mDimsForThisOre = new HashSet();

    public ItemBlockOre(Block block) {
        super(block);
        if (block instanceof BlockBaseOre) {
            this.mThisOre = (BlockBaseOre)block;
            this.mThisMaterial = this.mThisOre.getMaterialEx();
            this.mThisRadiation = this.mThisMaterial.vRadiationLevel;
        } else {
            this.mThisOre = null;
            this.mThisMaterial = null;
            this.mThisRadiation = 0;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List<String> list, boolean bool) {
        if (!mInitOres_Everglades) {
            for (WorldGen_GT_Ore_Layer f : WorldGen_Ores.validOreveins.values()) {
                Material[] m2;
                for (Material m1 : m2 = new Material[]{f.mPrimary, f.mSecondary, f.mBetween, f.mSporadic}) {
                    HashSet<String> aMap = mMapOreBlockItemToDimName.get(m1.getUnlocalizedName().toLowerCase());
                    if (aMap == null) {
                        aMap = new HashSet();
                    }
                    String aDimName = "Everglades";
                    aMap.add(aDimName);
                    mMapOreBlockItemToDimName.put(m1.getUnlocalizedName().toLowerCase(), aMap);
                }
            }
            mInitOres_Everglades = true;
        }
        if (this.mThisMaterial != null) {
            list.add(this.mThisMaterial.vChemicalFormula);
        }
        if (this.mThisRadiation > 0) {
            list.add(GTPPCore.GT_Tooltip_Radioactive.get());
        }
        if (this.mThisMaterial != null) {
            list.add("Ore contains:    ");
            if (this.mThisMaterial.getComposites().isEmpty()) {
                list.add("- " + this.mThisMaterial.getLocalizedName());
            } else {
                for (MaterialStack m : this.mThisMaterial.getComposites()) {
                    list.add("- " + m.getStackMaterial().getLocalizedName() + " x" + m.getPartsPerOneHundred());
                }
            }
        }
        if (KeyboardUtils.isCtrlKeyDown()) {
            HashSet<String> A;
            int aMiningLevel1;
            Block b = Block.func_149634_a((Item)stack.func_77973_b());
            if (b != null && (aMiningLevel1 = b.getHarvestLevel(stack.func_77960_j())) != 0) {
                list.add("Mining Level: " + Math.min(Math.max(aMiningLevel1, 0), 5));
            }
            if (this.mDimsForThisOre.isEmpty() && (A = mMapOreBlockItemToDimName.get(this.mThisMaterial.getUnlocalizedName().toLowerCase())) != null) {
                this.mDimsForThisOre = A;
            }
            list.add("Found:    ");
            if (!this.mDimsForThisOre.isEmpty()) {
                for (String m : this.mDimsForThisOre) {
                    list.add("- " + m);
                }
            } else {
                list.add("- Unknown");
            }
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + "Hold Ctrl to show additional info.");
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (this.mThisMaterial != null && this.mThisRadiation > 0 && entityHolding instanceof EntityPlayer && !((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d) {
            EntityUtils.applyRadiationDamageToEntity(iStack.field_77994_a, this.mThisMaterial.vRadiationLevel, world, entityHolding);
        }
    }
}

