/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.storage;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

@Deprecated
public class MTETieredChest
extends MTETieredMachineBlock
implements IAddUIWidgets {
    public int mItemCount = 0;
    public ItemStack mItemStack = null;
    private static final double mStorageFactor = 16875.0;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public MTETieredChest(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "This Chest stores " + (int)(Math.pow(6.0, aTier) * 16875.0) + " Items", new ITexture[0]);
    }

    public MTETieredChest(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.add((Object[])this.mDescriptionArray, (Object)GTPPCore.GT_Tooltip.get());
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETieredChest(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            if (this.getItemCount() <= 0) {
                this.mItemStack = null;
                this.mItemCount = 0;
            }
            if (this.mItemStack == null && this.mInventory[0] != null) {
                this.mItemStack = this.mInventory[0].func_77946_l();
            }
            if (this.mInventory[0] != null && this.mItemCount < this.getMaxItemCount() && GTUtility.areStacksEqual(this.mInventory[0], this.mItemStack)) {
                this.mItemCount += this.mInventory[0].field_77994_a;
                if (this.mItemCount > this.getMaxItemCount()) {
                    this.mInventory[0].field_77994_a = this.mItemCount - this.getMaxItemCount();
                    this.mItemCount = this.getMaxItemCount();
                } else {
                    this.mInventory[0] = null;
                }
            }
            if (this.mInventory[1] == null && this.mItemStack != null) {
                this.mInventory[1] = this.mItemStack.func_77946_l();
                this.mInventory[1].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
                this.mItemCount -= this.mInventory[1].field_77994_a;
            } else if (this.mItemCount > 0 && GTUtility.areStacksEqual(this.mInventory[1], this.mItemStack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a) {
                int tmp = Math.min(this.mItemCount, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                this.mInventory[1].field_77994_a += tmp;
                this.mItemCount -= tmp;
            }
            if (this.mItemStack != null) {
                this.mInventory[2] = this.mItemStack.func_77946_l();
                this.mInventory[2].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
            } else {
                this.mInventory[2] = null;
            }
        }
    }

    private int getItemCount() {
        return this.mItemCount;
    }

    @Override
    public void setItemCount(int aCount) {
        this.mItemCount = aCount;
    }

    @Override
    public int getProgresstime() {
        return this.mItemCount + (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a) + (this.mInventory[1] == null ? 0 : this.mInventory[1].field_77994_a);
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    @Override
    public int getMaxItemCount() {
        return (int)(Math.pow(6.0, this.mTier) * 16875.0 - 128.0);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == 0 && (this.mInventory[0] == null || GTUtility.areStacksEqual(this.mInventory[0], aStack));
    }

    @Override
    public String[] getInfoData() {
        String[] stringArray;
        if (this.mItemStack == null) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "Super Storage Chest";
            stringArray2[1] = "Stored Items:";
            stringArray2[2] = "No Items";
            stringArray2[3] = Integer.toString(0);
            stringArray = stringArray2;
            stringArray2[4] = Integer.toString(this.getMaxItemCount());
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "Super Storage Chest";
            stringArray3[1] = "Stored Items:";
            stringArray3[2] = this.mItemStack.func_82833_r();
            stringArray3[3] = Integer.toString(this.mItemCount);
            stringArray = stringArray3;
            stringArray3[4] = Integer.toString(this.getMaxItemCount());
        }
        return stringArray;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mItemCount", this.mItemCount);
        if (this.mItemStack != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.mItemStack.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mItemCount")) {
            this.mItemCount = aNBT.func_74762_e("mItemCount");
        }
        if (aNBT.func_74764_b("mItemStack")) {
            this.mItemStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("mItemStack")));
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aBaseMetaTileEntity.getFrontFacing() == ForgeDirection.DOWN && side == ForgeDirection.WEST) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GTRenderedTexture(Textures.BlockIcons.OVERLAY_QCHEST);
        } else if (side == aBaseMetaTileEntity.getFrontFacing()) {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = new GTRenderedTexture(Textures.BlockIcons.OVERLAY_QCHEST);
        } else {
            ITexture[] iTextureArray4 = new ITexture[1];
            iTextureArray = iTextureArray4;
            iTextureArray4[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
        }
        return iTextureArray;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(7, 16).setSize(71, 45))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_IN}).setPos(79, 16))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_OUT}).setPos(79, 52))).widget(SlotWidget.phantom((IItemHandlerModifiable)this.inventoryHandler, (int)2).disableInteraction().setBackground(new IDrawable[]{GTUITextures.TRANSPARENT}).setPos(59, 42))).widget(new TextWidget("Item Amount").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 20))).widget(new TextWidget().setStringSupplier(() -> numberFormat.format((long)this.mItemCount)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(10, 30));
    }
}

