/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.ItemStackData;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeGenBlastSmelterGTNH {
    private static final Map<String, FluidStack> mCachedIngotToFluidRegistry = new HashMap<String, FluidStack>();
    private static final Map<String, String> mCachedHotToColdRegistry = new HashMap<String, String>();

    private static synchronized void setIngotToFluid(ItemStackData stack, FluidStack fluid) {
        if (stack != null && fluid != null) {
            mCachedIngotToFluidRegistry.put(stack.getUniqueDataIdentifier(), fluid);
        }
    }

    private static synchronized void setHotToCold(ItemStackData hot, ItemStackData cold) {
        if (hot != null && cold != null) {
            mCachedHotToColdRegistry.put(hot.getUniqueDataIdentifier(), cold.getUniqueDataIdentifier());
        }
    }

    private static synchronized FluidStack getFluidFromIngot(ItemStackData ingot) {
        if (mCachedIngotToFluidRegistry.containsKey(ingot.getUniqueDataIdentifier())) {
            Logger.MACHINE_INFO("[ABS] mCachedIngotToFluidRegistry contains Output Ingot.", new Object[0]);
            return mCachedIngotToFluidRegistry.get(ingot.getUniqueDataIdentifier());
        }
        if (mCachedHotToColdRegistry.containsKey(ingot.getUniqueDataIdentifier())) {
            Logger.MACHINE_INFO("[ABS] mCachedHotToColdRegistry contains Output Ingot.", new Object[0]);
            return mCachedIngotToFluidRegistry.get(mCachedHotToColdRegistry.get(ingot.getUniqueDataIdentifier()));
        }
        Logger.MACHINE_INFO("[ABS] Neither Cache contains Output Ingot.", new Object[0]);
        return null;
    }

    private static boolean isValid(ItemStack[] inputs, ItemStack[] outputs, FluidStack[] fluidIn, FluidStack fluidOut) {
        return inputs != null && outputs != null && fluidIn != null && fluidOut != null && inputs.length > 0 && outputs.length > 0;
    }

    public static synchronized boolean generateGTNHBlastSmelterRecipesFromEBFList() {
        FluidStack validOutput;
        ItemStack validInput;
        int mSuccess = 0;
        Logger.INFO("[ABS] Starting recipe generation based on EBF recipe map.");
        Logger.INFO("[ABS] Caching Ingots and their Molten fluid..");
        for (GTRecipe x : RecipeMaps.fluidExtractionRecipes.getAllRecipes()) {
            validInput = null;
            validOutput = null;
            if (ArrayUtils.isEmpty((Object[])x.mInputs) || ArrayUtils.isEmpty((Object[])x.mFluidOutputs)) continue;
            for (int tag : OreDictionary.getOreIDs((ItemStack)x.mInputs[0])) {
                String mType;
                String oreName = OreDictionary.getOreName((int)tag).toLowerCase();
                if (!oreName.startsWith(mType = "ingot") || oreName.contains("double") || oreName.contains("triple") || oreName.contains("quad") || oreName.contains("quintuple")) continue;
                validInput = x.mInputs[0];
            }
            validOutput = x.mFluidOutputs[0];
            if (validInput == null) continue;
            ItemStackData R = new ItemStackData(validInput);
            RecipeGenBlastSmelterGTNH.setIngotToFluid(R, validOutput);
            Logger.MACHINE_INFO("[ABS][I2F] Cached " + validInput.func_82833_r() + " to " + validOutput.getLocalizedName() + ". Stored Under ID of " + R.getUniqueDataIdentifier(), new Object[0]);
        }
        Logger.INFO("[ABS] Caching Ingots and their Hot form...");
        for (GTRecipe x : RecipeMaps.vacuumFreezerRecipes.getAllRecipes()) {
            validInput = null;
            validOutput = null;
            if (ArrayUtils.isNotEmpty((Object[])x.mInputs) && x.mInputs[0] != null) {
                validInput = x.mInputs[0];
            }
            if (ArrayUtils.isNotEmpty((Object[])x.mOutputs) && x.mOutputs[0] != null) {
                validOutput = x.mOutputs[0];
            }
            if (validInput == null || validOutput == null) continue;
            ItemStackData R1 = new ItemStackData(validInput);
            ItemStackData R2 = new ItemStackData((ItemStack)validOutput);
            RecipeGenBlastSmelterGTNH.setHotToCold(R1, R2);
            Logger.MACHINE_INFO("[ABS][H2C] Cached " + validInput.func_82833_r() + " to " + validOutput.func_82833_r() + ". Stored Under ID of " + R1.getUniqueDataIdentifier() + ", links to ID " + R2.getUniqueDataIdentifier(), new Object[0]);
        }
        Logger.INFO("[ABS] Generating recipes based on existing EBF recipes.");
        for (GTRecipe x : RecipeMaps.blastFurnaceRecipes.getAllRecipes()) {
            ItemStack[] inputs = (ItemStack[])x.mInputs.clone();
            ItemStack[] outputs = (ItemStack[])x.mOutputs.clone();
            FluidStack[] inputsF = (FluidStack[])x.mFluidInputs.clone();
            int voltage = x.mEUt;
            int time = x.mDuration;
            boolean enabled = x.mEnabled;
            int special = x.mSpecialValue;
            if (special > 3600) {
                Logger.MACHINE_INFO("[ABS] Skipping ABS addition for GTNH due to temp.", new Object[0]);
                continue;
            }
            FluidStack mMoltenStack = null;
            int mMoltenCount = 0;
            if (x.mOutputs != null && x.mOutputs[0] != null) {
                mMoltenCount = x.mOutputs[0].field_77994_a;
                ItemStackData R = new ItemStackData(x.mOutputs[0]);
                Logger.MACHINE_INFO("[ABS] Found " + x.mOutputs[0].func_82833_r() + " as valid EBF output, finding it's fluid from the cache. We will require " + 144 * mMoltenCount + "L. Looking for ID " + R.getUniqueDataIdentifier(), new Object[0]);
                FluidStack tempFluid = RecipeGenBlastSmelterGTNH.getFluidFromIngot(R);
                if (tempFluid != null) {
                    mMoltenStack = FluidUtils.getFluidStack(tempFluid, mMoltenCount * 144);
                } else {
                    Logger.MACHINE_INFO("[ABS] Failed to get Fluid from Cache.", new Object[0]);
                }
            }
            if (enabled && RecipeGenBlastSmelterGTNH.isValid(inputs, outputs, inputsF, mMoltenStack)) {
                boolean circuitFound = false;
                ArrayList<ItemStack> aTempList = new ArrayList<ItemStack>();
                for (ItemStack recipeItem : inputs) {
                    if (ItemUtils.isControlCircuit(recipeItem)) {
                        circuitFound = true;
                    }
                    aTempList.add(recipeItem);
                }
                inputs = aTempList.toArray(new ItemStack[0]);
                int inputLength = inputs.length;
                if (!circuitFound) {
                    ++inputLength;
                }
                ItemStack[] newInput = new ItemStack[inputLength];
                int l = 0;
                if (!circuitFound) {
                    l = 1;
                    newInput[0] = GTUtility.getIntegratedCircuit(inputs.length);
                }
                for (ItemStack y : inputs) {
                    newInput[l++] = y;
                }
                GTValues.RA.stdBuilder().itemInputs(newInput).fluidInputs(inputsF).fluidOutputs(mMoltenStack).duration(MathUtils.roundToClosestInt((double)time * 0.8)).eut(voltage).recipeCategory(inputLength <= 2 ? RecipeCategories.absNonAlloyRecipes : GTPPRecipeMaps.alloyBlastSmelterRecipes.getDefaultRecipeCategory()).addTo(GTPPRecipeMaps.alloyBlastSmelterRecipes);
                continue;
            }
            if (!enabled) {
                Logger.MACHINE_INFO("[ABS] Failure. EBF recipe was not enabled.", new Object[0]);
                continue;
            }
            Logger.MACHINE_INFO("[ABS] Failure. Invalid Inputs or Outputs.", new Object[0]);
            if (inputs == null) {
                Logger.MACHINE_INFO("[ABS] Inputs were not Valid.", new Object[0]);
            } else {
                Logger.MACHINE_INFO("[ABS] inputs size: " + inputs.length, new Object[0]);
            }
            if (outputs == null) {
                Logger.MACHINE_INFO("[ABS] Outputs were not Valid.", new Object[0]);
            } else {
                Logger.MACHINE_INFO("[ABS] outputs size: " + outputs.length, new Object[0]);
            }
            if (inputsF == null) {
                Logger.MACHINE_INFO("[ABS] Input Fluids were not Valid.", new Object[0]);
            } else {
                Logger.MACHINE_INFO("[ABS] inputsF size: " + inputsF.length, new Object[0]);
            }
            if (mMoltenStack != null) continue;
            Logger.MACHINE_INFO("[ABS] Output Fluid were not Valid.", new Object[0]);
        }
        Logger.INFO("[ABS] Processed " + mSuccess + " recipes.");
        return mSuccess > 0;
    }
}

