/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.util.HashMap;
import journeymap.client.data.DataCache;
import journeymap.client.model.EntityDTO;

public class MapType {
    private static HashMap<Integer, MapType> cache = new HashMap(256);
    public final Integer vSlice;
    public final Name name;
    public final int dimension;
    private final int theHashCode;
    private final String theCacheKey;

    public MapType(Name name, Integer vSlice, int dimension) {
        vSlice = name != Name.underground ? null : vSlice;
        this.name = name;
        this.vSlice = vSlice;
        this.dimension = dimension;
        this.theCacheKey = MapType.toCacheKey(name, vSlice, dimension);
        this.theHashCode = this.theCacheKey.hashCode();
    }

    public static MapType from(Name name, Integer vSlice, int dimension) {
        return DataCache.instance().getMapType(name, vSlice, dimension);
    }

    public static MapType from(Integer vSlice, int dimension) {
        return MapType.from(vSlice == null ? Name.surface : Name.underground, vSlice, dimension);
    }

    public static MapType from(Name name, EntityDTO player) {
        return MapType.from(name, player.chunkCoordY, player.dimension);
    }

    public static MapType day(int dimension) {
        return MapType.from(Name.day, null, dimension);
    }

    public static MapType day(EntityDTO player) {
        return MapType.from(Name.day, null, player.dimension);
    }

    public static MapType night(int dimension) {
        return MapType.from(Name.night, null, dimension);
    }

    public static MapType night(EntityDTO player) {
        return MapType.from(Name.night, null, player.dimension);
    }

    public static MapType underground(EntityDTO player) {
        return MapType.from(Name.underground, player.chunkCoordY, player.dimension);
    }

    public static MapType underground(Integer vSlice, int dimension) {
        return MapType.from(Name.underground, vSlice, dimension);
    }

    public static String toCacheKey(Name name, Integer vSlice, int dimension) {
        return "" + dimension + (Object)((Object)name) + vSlice;
    }

    public String toCacheKey() {
        return this.theCacheKey;
    }

    public String toString() {
        return this.name.name();
    }

    public String name() {
        return this.name.name();
    }

    public boolean isUnderground() {
        return this.name == Name.underground;
    }

    public boolean isSurface() {
        return this.name == Name.surface;
    }

    public boolean isDay() {
        return this.name == Name.day;
    }

    public boolean isNight() {
        return this.name == Name.night;
    }

    public int hashCode() {
        return this.theHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapType mapType = (MapType)o;
        if (this.dimension != mapType.dimension) {
            return false;
        }
        if (this.name != mapType.name) {
            return false;
        }
        return !(this.vSlice != null ? !this.vSlice.equals(mapType.vSlice) : mapType.vSlice != null);
    }

    public static enum Name {
        day,
        night,
        underground,
        surface;

    }
}

