/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.postea.api;

import com.gtnewhorizons.postea.utility.BlockConversionInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.world.World;

public class BlockReplacementManager {
    public static final Map<String, BiFunction<BlockConversionInfo, World, BlockConversionInfo>> blockReplacementMap = new HashMap<String, BiFunction<BlockConversionInfo, World, BlockConversionInfo>>();
    public static final HashSet<Integer> posteaMarkedIDs = new HashSet();

    public static void addBlockReplacement(String blockNameIn, BiFunction<BlockConversionInfo, World, BlockConversionInfo> transformer) {
        blockReplacementMap.put(blockNameIn, transformer);
    }

    public static BlockConversionInfo getBlockReplacement(BlockConversionInfo blockConversionInfo, World world) {
        BiFunction transformer = blockReplacementMap.getOrDefault(blockConversionInfo.blockName, null);
        if (transformer == null) {
            return null;
        }
        return (BlockConversionInfo)transformer.apply(blockConversionInfo, world);
    }

    public static boolean blockNotConvertible(int blockID) {
        return !posteaMarkedIDs.contains(blockID);
    }
}

