/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenerator;

public abstract class TFTreeGenerator
extends WorldGenAbstractTree {
    protected Block treeBlock = TFBlocks.log;
    protected int treeMeta = 3;
    protected int branchMeta = 15;
    protected Block leafBlock = TFBlocks.hedge;
    protected int leafMeta = 1;
    protected Block rootBlock = TFBlocks.root;
    protected int rootMeta = 0;

    public TFTreeGenerator() {
        this(false);
    }

    public TFTreeGenerator(boolean par1) {
        super(par1);
    }

    protected void buildRoot(World world, int x, int y, int z, double offset, int b) {
        ChunkCoordinates[] lineArray;
        ChunkCoordinates dest = TFTreeGenerator.translateCoords(x, y - b - 2, z, 5.0, 0.3 * (double)b + offset, 0.8);
        for (ChunkCoordinates coord : lineArray = TFTreeGenerator.getBresehnamArrayCoords(x, y - b - 2, z, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c)) {
            this.placeRootBlock(world, coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, this.rootBlock, this.rootMeta);
        }
    }

    protected void placeRootBlock(World world, int x, int y, int z, Block rootBlock2, int meta) {
        if (TFTreeGenerator.canRootGrowIn(world, x, y, z)) {
            this.setBlockAndMetadata(world, x, y, z, rootBlock2, meta);
        }
    }

    public static boolean canRootGrowIn(World world, int x, int y, int z) {
        Block blockID = world.func_147439_a(x, y, z);
        if (blockID == Blocks.field_150350_a) {
            return TFTreeGenerator.isNearSolid(world, x, y, z);
        }
        return blockID != Blocks.field_150357_h && blockID != Blocks.field_150343_Z && blockID != TFBlocks.shield;
    }

    public static int[] translate(int sx, int sy, int sz, double distance, double angle, double tilt) {
        return TFGenerator.translate(sx, sy, sz, distance, angle, tilt);
    }

    protected static ChunkCoordinates translateCoords(int sx, int sy, int sz, double length, double angle, double tilt) {
        return TFGenerator.translateCoords(sx, sy, sz, length, angle, tilt);
    }

    public static ChunkCoordinates[] getBresehnamArrayCoords(ChunkCoordinates src, ChunkCoordinates dest) {
        return TFGenerator.getBresehnamArrayCoords(src.field_71574_a, src.field_71572_b, src.field_71573_c, dest.field_71574_a, dest.field_71572_b, dest.field_71573_c);
    }

    public static ChunkCoordinates[] getBresehnamArrayCoords(int x1, int y1, int z1, int x2, int y2, int z2) {
        return TFGenerator.getBresehnamArrayCoords(x1, y1, z1, x2, y2, z2);
    }

    protected static boolean isNearSolid(World world, int bx, int by, int bz) {
        return TFGenerator.isNearSolid(world, bx, by, bz);
    }

    protected static boolean hasAirAround(World world, int bx, int by, int bz) {
        return TFGenerator.hasAirAround(world, bx, by, bz);
    }

    protected void setBlock(World world, int x, int y, int z, Block block) {
        this.func_150515_a(world, x, y, z, block);
    }

    protected void setBlockAndMetadata(World world, int x, int y, int z, Block block, int meta) {
        this.func_150516_a(world, x, y, z, block, meta);
    }

    public void makeLeafCircle(World world, int sx, int sy, int sz, int rad, Block blockValue, int metaValue) {
        this.makeLeafCircle(world, sx, sy, sz, rad, blockValue, metaValue, false);
    }

    protected void drawBresehnam(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block blockValue, int metaValue) {
        ChunkCoordinates[] lineArray;
        for (ChunkCoordinates pixel : lineArray = TFTreeGenerator.getBresehnamArrayCoords(x1, y1, z1, x2, y2, z2)) {
            this.setBlockAndMetadata(world, pixel.field_71574_a, pixel.field_71572_b, pixel.field_71573_c, blockValue, metaValue);
        }
    }

    public void makeLeafCircle(World world, int sx, int sy, int sz, int rad, Block blockValue, int metaValue, boolean useHack) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = Math.max(dx, dz) + (Math.min(dx, dz) >> 1);
                if (useHack && dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dist > rad) continue;
                this.putLeafBlock(world, sx + dx, sy, sz + dz, blockValue, metaValue);
                this.putLeafBlock(world, sx + dx, sy, sz - dz, blockValue, metaValue);
                this.putLeafBlock(world, sx - dx, sy, sz + dz, blockValue, metaValue);
                this.putLeafBlock(world, sx - dx, sy, sz - dz, blockValue, metaValue);
            }
        }
    }

    public void makeLeafCircle2(World world, int sx, int sy, int sz, int rad, Block blockValue, int metaValue, boolean useHack) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                if (dx * dx + dz * dz > rad * rad) continue;
                this.putLeafBlock(world, sx + 1 + dx, sy, sz + 1 + dz, blockValue, metaValue);
                this.putLeafBlock(world, sx + 1 + dx, sy, sz - dz, blockValue, metaValue);
                this.putLeafBlock(world, sx - dx, sy, sz + 1 + dz, blockValue, metaValue);
                this.putLeafBlock(world, sx - dx, sy, sz - dz, blockValue, metaValue);
            }
        }
    }

    public void drawLeafBlob(World world, int sx, int sy, int sz, int rad, Block blockValue, int metaValue) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    int dist = 0;
                    dist = dx >= dy && dx >= dz ? dx + (Math.max(dy, dz) >> 1) + (Math.min(dy, dz) >> 2) : (dy >= dx && dy >= dz ? dy + (Math.max(dx, dz) >> 1) + (Math.min(dx, dz) >> 2) : dz + (Math.max(dx, dy) >> 1) + (Math.min(dx, dy) >> 2));
                    if (dist > rad) continue;
                    this.putLeafBlock(world, sx + dx, sy + dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx + dx, sy + dy, sz - dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy + dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy + dy, sz - dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx + dx, sy - dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx + dx, sy - dy, sz - dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy - dy, sz + dz, blockValue, metaValue);
                    this.putLeafBlock(world, sx - dx, sy - dy, sz - dz, blockValue, metaValue);
                }
            }
        }
    }

    public void putLeafBlock(World world, int x, int y, int z, Block blockValue, int metaValue) {
        Block whatsThere = world.func_147439_a(x, y, z);
        Block block = whatsThere;
        if (block == null || block.canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) {
            this.setBlockAndMetadata(world, x, y, z, blockValue, metaValue);
        }
    }
}

