/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MessageTileUpdate
implements IMessage {
    int worldId;
    int x;
    int y;
    int z;
    NBTTagCompound tag;

    public MessageTileUpdate() {
    }

    public MessageTileUpdate(TileEntity te) {
        try {
            this.worldId = te.func_145831_w().field_73011_w.field_76574_g;
            this.x = te.field_145851_c;
            this.y = te.field_145848_d;
            this.z = te.field_145849_e;
            this.tag = new NBTTagCompound();
            te.func_145841_b(this.tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.worldId);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public void fromBytes(ByteBuf buf) {
        this.worldId = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class HandlerServer
    implements IMessageHandler<MessageTileUpdate, IMessage> {
        public IMessage onMessage(MessageTileUpdate message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.worldId);
            if (world != null && world.func_147438_o(message.x, message.y, message.z) != null) {
                world.func_147438_o(message.x, message.y, message.z).func_145839_a(message.tag);
            }
            return null;
        }
    }
}

