/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.proxy;

import com.google.common.base.Objects;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.angelica.compat.bettercrashes.BetterCrashesCompat;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.config.CompatConfig;
import com.gtnewhorizons.angelica.debug.F3Direction;
import com.gtnewhorizons.angelica.debug.FrametimeGraph;
import com.gtnewhorizons.angelica.debug.TPSGraph;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.debug.OpenGLDebugging;
import com.gtnewhorizons.angelica.hudcaching.HUDCaching;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.mixins.interfaces.IGameSettingsExt;
import com.gtnewhorizons.angelica.models.VanillaModels;
import com.gtnewhorizons.angelica.proxy.CommonProxy;
import com.gtnewhorizons.angelica.render.CloudRenderer;
import com.gtnewhorizons.angelica.rendering.AngelicaBlockSafetyRegistry;
import com.gtnewhorizons.angelica.utils.AssetLoader;
import com.gtnewhorizons.angelica.zoom.Zoom;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import jss.notfine.core.Settings;
import me.jellysquid.mods.sodium.client.SodiumDebugScreenHandler;
import net.coderbot.iris.Iris;
import net.coderbot.iris.client.IrisDebugScreenHandler;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.input.Keyboard;

public class ClientProxy
extends CommonProxy {
    final Minecraft mc = Minecraft.func_71410_x();
    final FrametimeGraph frametimeGraph = new FrametimeGraph();
    final TPSGraph tpsGraph = new TPSGraph();
    private static KeyBinding glsmKeyBinding;
    private boolean wasGLSMKeyPressed;
    float lastIntegratedTickTime;
    private float gameStartTime = -1.0f;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        AssetLoader.load();
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (GLStateManager.isRunningSplash()) {
            GLStateManager.setRunningSplash(false);
            AngelicaTweaker.LOGGER.info("World loaded - Enabling GLSM Cache");
        }
        if (AngelicaConfig.enableSodium) {
            GameData.getBlockRegistry().typeSafeIterable().forEach(o -> {
                AngelicaBlockSafetyRegistry.canBlockRenderOffThread(o, true, true);
                AngelicaBlockSafetyRegistry.canBlockRenderOffThread(o, false, true);
            });
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        if (AngelicaConfig.enableHudCaching) {
            FMLCommonHandler.instance().bus().register((Object)HUDCaching.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)HUDCaching.INSTANCE);
        }
        if (AngelicaConfig.enableSodium) {
            MinecraftForge.EVENT_BUS.register((Object)SodiumDebugScreenHandler.INSTANCE);
        }
        if (AngelicaConfig.enableIris) {
            MinecraftForge.EVENT_BUS.register((Object)IrisDebugScreenHandler.INSTANCE);
            Iris.INSTANCE.fmlInitEvent();
            FMLCommonHandler.instance().bus().register((Object)Iris.INSTANCE);
            MinecraftForge.EVENT_BUS.register((Object)Iris.INSTANCE);
            VertexFormat.registerSetupBufferStateOverride((vertexFormat, l) -> {
                if (vertexFormat == DefaultVertexFormat.POSITION_COLOR_TEXTURE_LIGHT_NORMAL || vertexFormat == DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP) {
                    IrisVertexFormats.TERRAIN.setupBufferState(l);
                    return true;
                }
                return false;
            });
            VertexFormat.registerClearBufferStateOverride(vertexFormat -> {
                if (vertexFormat == DefaultVertexFormat.POSITION_COLOR_TEXTURE_LIGHT_NORMAL || vertexFormat == DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP) {
                    IrisVertexFormats.TERRAIN.clearBufferState();
                    return true;
                }
                return false;
            });
        }
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        glsmKeyBinding = new KeyBinding("Print GLSM Debug", 0, "Angelica");
        ClientRegistry.registerKeyBinding((KeyBinding)glsmKeyBinding);
        VanillaModels.init();
        if (ModStatus.isBetterCrashesLoaded) {
            BetterCrashesCompat.init();
        }
        if (AngelicaConfig.enableZoom) {
            Zoom.init();
        }
    }

    @SubscribeEvent
    public void onKeypress(TickEvent.ClientTickEvent event) {
        boolean isPressed;
        boolean bl = isPressed = glsmKeyBinding.func_151463_i() != 0 && Keyboard.isKeyDown((int)glsmKeyBinding.func_151463_i());
        if (isPressed && !this.wasGLSMKeyPressed) {
            OpenGLDebugging.checkGLSM();
        }
        this.wasGLSMKeyPressed = isPressed;
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        if (ModStatus.isLotrLoaded && AngelicaConfig.enableSodium && CompatConfig.fixLotr) {
            try {
                Class<?> lotrRendering = Class.forName("lotr.common.coremod.LOTRReplacedMethods$BlockRendering");
                ReflectionHelper.setPrivateValue(lotrRendering, null, new ConcurrentHashMap(), (String[])new String[]{"naturalBlockClassTable"});
                ReflectionHelper.setPrivateValue(lotrRendering, null, new ConcurrentHashMap(), (String[])new String[]{"naturalBlockTable"});
                ReflectionHelper.setPrivateValue(lotrRendering, null, new ConcurrentHashMap(), (String[])new String[]{"cachedNaturalBlocks"});
            }
            catch (ClassNotFoundException e) {
                AngelicaTweaker.LOGGER.error("Could not replace LOTR handle render code with thread safe version");
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient() && event.phase == TickEvent.Phase.END) {
            IntegratedServer srv = Minecraft.func_71410_x().func_71401_C();
            if (srv != null) {
                long currentTickTime = srv.field_71311_j[srv.func_71259_af() % 100];
                this.lastIntegratedTickTime = this.lastIntegratedTickTime * 0.8f + (float)currentTickTime / 1000000.0f * 0.2f;
            } else {
                this.lastIntegratedTickTime = 0.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.isCanceled() || !this.mc.field_71474_y.field_74330_P) {
            return;
        }
        if (AngelicaConfig.modernizeF3Screen && event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            F3Direction.renderWorldDirectionsEvent(this.mc, event);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        IntegratedServer srv;
        Minecraft mc = Minecraft.func_71410_x();
        if (event.isCanceled() || !mc.field_71474_y.field_74330_P || event.left.isEmpty()) {
            return;
        }
        NetHandlerPlayClient cl = mc.func_147114_u();
        if (cl != null && (srv = mc.func_71401_C()) != null) {
            String s = String.format("Integrated server @ %.0f ms ticks", Float.valueOf(this.lastIntegratedTickTime));
            event.left.add(Math.min(event.left.size(), 1), s);
        }
        if (AngelicaConfig.showBlockDebugInfo && mc.field_71476_x != null && mc.field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (!event.right.isEmpty() && !((String)Objects.firstNonNull((Object)((String)event.right.get(event.right.size() - 1)), (Object)"")).isEmpty()) {
                event.right.add("");
            }
            Block block = mc.field_71441_e.func_147439_a(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
            int meta = mc.field_71441_e.func_72805_g(mc.field_71476_x.field_72311_b, mc.field_71476_x.field_72312_c, mc.field_71476_x.field_72309_d);
            event.right.add(Block.field_149771_c.func_148750_c((Object)block));
            event.right.add("meta: " + meta);
        }
        if (DynamicLights.isEnabled()) {
            StringBuilder builder = new StringBuilder("Dynamic Light Sources: ");
            DynamicLights dl = DynamicLights.get();
            builder.append(dl.getLightSourcesCount()).append(" (U: ").append(dl.getLastUpdateCount()).append(')');
            event.right.add(builder.toString());
        }
        if (AngelicaConfig.modernizeF3Screen) {
            boolean hasReplacedXYZ = false;
            for (int i = 0; i < event.left.size() - 3; ++i) {
                String string;
                if (hasReplacedXYZ || !((String)Objects.firstNonNull((Object)((String)event.left.get(i)), (Object)"")).startsWith("x:") || !((String)Objects.firstNonNull((Object)((String)event.left.get(i + 1)), (Object)"")).startsWith("y:") || !((String)Objects.firstNonNull((Object)((String)event.left.get(i + 2)), (Object)"")).startsWith("z:") || !((String)Objects.firstNonNull((Object)((String)event.left.get(i + 3)), (Object)"")).startsWith("f:")) continue;
                hasReplacedXYZ = true;
                int heading = MathHelper.func_76128_c((double)((double)(mc.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                switch (heading) {
                    case 0: {
                        string = "Towards positive Z";
                        break;
                    }
                    case 1: {
                        string = "Towards negative X";
                        break;
                    }
                    case 2: {
                        string = "Towards negative Z";
                        break;
                    }
                    case 3: {
                        string = "Towards positive X";
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                String heading_str = string;
                event.left.set(i, String.format("XYZ: %.3f / %.5f / %.3f", mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70121_D.field_72338_b, mc.field_71439_g.field_70161_v));
                int bX = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
                int bY = MathHelper.func_76128_c((double)mc.field_71439_g.field_70121_D.field_72338_b);
                int bZ = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
                event.left.set(i + 1, String.format("Block: %d %d %d [%d %d %d]", bX, bY, bZ, bX & 0xF, bY & 0xF, bZ & 0xF));
                event.left.set(i + 2, String.format("Chunk: %d %d %d", bX >> 4, bY >> 4, bZ >> 4));
                event.left.set(i + 3, String.format("Facing: %s (%s) (%.1f / %.1f)", Direction.field_82373_c[heading].toLowerCase(Locale.ROOT), heading_str, Float.valueOf(MathHelper.func_76142_g((float)mc.field_71439_g.field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)mc.field_71439_g.field_70125_A))));
                Chunk chunk = this.mc.field_71441_e.func_72938_d(bX, bZ);
                event.left.set(i + 4, String.format("lc: %d b: %s bl: %d sl: %d rl: %d", chunk.func_76625_h() + 15, chunk.func_76591_a((int)(bX & 0xF), (int)(bZ & 0xF), (WorldChunkManager)mc.field_71441_e.func_72959_q()).field_76791_y, chunk.func_76614_a(EnumSkyBlock.Block, bX & 0xF, MathHelper.func_76125_a((int)bY, (int)0, (int)255), bZ & 0xF), chunk.func_76614_a(EnumSkyBlock.Sky, bX & 0xF, MathHelper.func_76125_a((int)bY, (int)0, (int)255), bZ & 0xF), chunk.func_76629_c(bX & 0xF, MathHelper.func_76125_a((int)bY, (int)0, (int)255), bZ & 0xF, 0)));
            }
            event.setCanceled(true);
            FontRenderer fontrenderer = mc.field_71466_p;
            int fontColor = 0xE0E0E0;
            int rectColor = -1873784752;
            for (int x = 0; x < event.left.size(); ++x) {
                String msg = (String)event.left.get(x);
                if (msg == null) continue;
                int strX = 2;
                int strY = 2 + x * fontrenderer.field_78288_b;
                Gui.func_73734_a((int)1, (int)(strY - 1), (int)(strX + fontrenderer.func_78256_a(msg) + 1), (int)(strY + fontrenderer.field_78288_b - 1), (int)rectColor);
                fontrenderer.func_78276_b(msg, strX, strY, fontColor);
            }
            int width = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d).func_78326_a();
            for (int x = 0; x < event.right.size(); ++x) {
                String msg = (String)event.right.get(x);
                if (msg == null) continue;
                int w = fontrenderer.func_78256_a(msg);
                int strX = width - w - 2;
                int strY = 2 + x * fontrenderer.field_78288_b;
                Gui.func_73734_a((int)(strX - 1), (int)(strY - 1), (int)(strX + w + 1), (int)(strY + fontrenderer.field_78288_b - 1), (int)rectColor);
                fontrenderer.func_78276_b(msg, strX, strY, fontColor);
            }
            if (((IGameSettingsExt)mc.field_71474_y).angelica$showFpsGraph()) {
                this.frametimeGraph.render();
                if (Minecraft.func_71410_x().func_71356_B()) {
                    this.tpsGraph.render();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (!event.isCanceled() && event.gui instanceof GuiMainMenu && this.gameStartTime == -1.0f) {
            this.gameStartTime = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            AngelicaTweaker.LOGGER.info("The game loaded in {} seconds.", new Object[]{Float.valueOf(this.gameStartTime)});
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        if (Float.isNaN(event.red)) {
            event.red = 0.0f;
        }
        if (Float.isNaN(event.green)) {
            event.green = 0.0f;
        }
        if (Float.isNaN(event.blue)) {
            event.blue = 0.0f;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.mc.field_71441_e != null) {
            CloudRenderer.getCloudRenderer().checkSettings();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFOVModifierUpdate(FOVUpdateEvent event) {
        if (!((Boolean)Settings.DYNAMIC_FOV.option.getStore()).booleanValue()) {
            event.newfov = 1.0f;
        }
    }

    @Override
    public void putFrametime(long time) {
        this.frametimeGraph.putSample(time);
    }

    @Override
    public void putTicktime(long time) {
        this.tpsGraph.putSample(time);
    }
}

