/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.nei.BuggyRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.CircuitFabricatorRecipeHandler;
import micdoodle8.mods.galacticraft.core.nei.GCNEIHighlightHandler;
import micdoodle8.mods.galacticraft.core.nei.RefineryRecipeHandler;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class NEIGalacticraftConfig
implements IConfigureNEI {
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> rocketBenchRecipes = new HashMap();
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> buggyBenchRecipes = new HashMap();
    private static final HashMap<PositionedStack, PositionedStack> refineryRecipes = new HashMap();
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap();
    private static final HashMap<HashMap<Integer, PositionedStack>, PositionedStack> ingotCompressorRecipes = new HashMap();

    public void loadConfig() {
        this.registerRecipes();
        for (Item item : GCItems.hiddenItems) {
            API.hideItem((ItemStack)new ItemStack(item, 1, 0));
        }
        for (Block block : GCBlocks.hiddenBlocks) {
            API.hideItem((ItemStack)new ItemStack(block, 1, 0));
            if (block != GCBlocks.slabGCDouble) continue;
            for (int j = 1; j < 6; ++j) {
                API.hideItem((ItemStack)new ItemStack(block, 1, j));
            }
        }
        API.registerRecipeHandler((ICraftingHandler)new BuggyRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BuggyRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RefineryRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RefineryRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CircuitFabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CircuitFabricatorRecipeHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.basicBlock, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.blockMoon, (IHighlightHandler)new GCNEIHighlightHandler());
        API.registerHighlightIdentifier((Block)GCBlocks.fakeBlock, (IHighlightHandler)new GCNEIHighlightHandler());
    }

    public String getName() {
        return "Galacticraft NEI Plugin";
    }

    public String getVersion() {
        return "3.2.5-GTNH";
    }

    public void registerIngotCompressorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        ingotCompressorRecipes.put(input, output);
    }

    public void registerCircuitFabricatorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public void registerRocketBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        rocketBenchRecipes.put(input, output);
    }

    public void registerBuggyBenchRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        buggyBenchRecipes.put(input, output);
    }

    public void registerRefineryRecipe(PositionedStack input, PositionedStack output) {
        refineryRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getIngotCompressorRecipes() {
        return ingotCompressorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getRocketBenchRecipes() {
        return rocketBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getBuggyBenchRecipes() {
        return buggyBenchRecipes.entrySet();
    }

    public static Set<Map.Entry<PositionedStack, PositionedStack>> getRefineryRecipes() {
        return refineryRecipes.entrySet();
    }

    public void registerRecipes() {
        this.registerRefineryRecipe(new PositionedStack((Object)new ItemStack(GCItems.oilCanister, 1, 1), 2, 3), new PositionedStack((Object)new ItemStack(GCItems.fuelCanister, 1, 1), 148, 3));
        this.addCircuitFabricatorRecipes();
        this.addIngotCompressorRecipes();
    }

    private void addCircuitFabricatorRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        input1.put(0, new PositionedStack((Object)new ItemStack(Items.field_151045_i), 10, 22));
        int siliconCount = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).size();
        ItemStack[] silicons = new ItemStack[siliconCount];
        for (int j = 0; j < siliconCount; ++j) {
            silicons[j] = (ItemStack)OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).get(j);
        }
        input1.put(1, new PositionedStack((Object)silicons, 69, 51));
        input1.put(2, new PositionedStack((Object)silicons, 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Items.field_151137_ax), 117, 51));
        input1.put(4, new PositionedStack((Object)new ItemStack(Blocks.field_150429_aA), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 5 : 3, 13), 147, 91));
        HashMap<Integer, PositionedStack> input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151100_aR, 1, 4), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, 9, 12), 147, 91));
        input2 = new HashMap<Integer, PositionedStack>(input1);
        input2.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
        this.registerCircuitFabricatorRecipe(input2, new PositionedStack((Object)new ItemStack(GCItems.basicItem, ConfigManagerCore.quickMode ? 2 : 1, 14), 147, 91));
    }

    private void addIngotCompressorRecipes() {
        for (IRecipe rec : CompressorRecipes.getRecipeList()) {
            int j;
            HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
            if (rec instanceof ShapedRecipes) {
                ShapedRecipes recipe = (ShapedRecipes)rec;
                for (j = 0; j < recipe.field_77574_d.length; ++j) {
                    ItemStack stack = recipe.field_77574_d[j];
                    input1.put(j, new PositionedStack((Object)stack, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            } else if (rec instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe recipe = (ShapelessOreRecipe)rec;
                for (j = 0; j < recipe.getInput().size(); ++j) {
                    Object obj = recipe.getInput().get(j);
                    input1.put(j, new PositionedStack(obj, 21 + j % 3 * 18, 26 + j / 3 * 18));
                }
            }
            ItemStack resultItemStack = rec.func_77571_b();
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b().func_77667_c(resultItemStack).contains("compressed")) {
                resultItemStack.field_77994_a *= 2;
            }
            this.registerIngotCompressorRecipe(input1, new PositionedStack((Object)resultItemStack, 140, 46));
        }
    }
}

