/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import com.google.common.base.Optional;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PacketSetRecipe
implements IMessage {
    private NBTTagCompound recipe;

    public PacketSetRecipe() {
    }

    public PacketSetRecipe(NBTTagCompound recipe) {
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipe = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.recipe);
    }

    private IGrid getNetwork(AEBaseContainer container) {
        if (container.getTarget() instanceof IActionHost) {
            IActionHost ah = (IActionHost)container.getTarget();
            IGridNode gn = ah.getActionableNode();
            return gn.getGrid();
        }
        return null;
    }

    private ItemStack getPatternStack(EntityPlayer player, NBTTagCompound recipe) {
        ItemStack[] recipeInputs = new ItemStack[9];
        for (int i = 0; i < recipeInputs.length; ++i) {
            NBTTagCompound currentStack = recipe.func_74775_l("#" + i);
            recipeInputs[i] = currentStack == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentStack);
        }
        InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        for (int i = 0; i < 9; ++i) {
            ic.func_70299_a(i, recipeInputs[i]);
        }
        ItemStack result = CraftingManager.func_77594_a().func_82787_a(ic, player.field_70170_p);
        if (result != null) {
            ItemStack patternStack = null;
            Optional maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1);
            if (maybePattern.isPresent()) {
                patternStack = (ItemStack)maybePattern.get();
            }
            if (patternStack != null) {
                NBTTagCompound patternValue = new NBTTagCompound();
                NBTTagList tagIn = new NBTTagList();
                for (ItemStack stack : recipeInputs) {
                    tagIn.func_74742_a((NBTBase)this.crateItemTag(stack));
                }
                patternValue.func_74782_a("in", (NBTBase)tagIn);
                patternValue.func_74782_a("out", (NBTBase)result.func_77955_b(new NBTTagCompound()));
                patternValue.func_74757_a("crafting", true);
                patternValue.func_74757_a("substitute", false);
                patternStack.func_77982_d(patternValue);
                return patternStack;
            }
        }
        return null;
    }

    private NBTTagCompound crateItemTag(ItemStack itemStack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (itemStack != null) {
            itemStack.func_77955_b(tag);
        }
        return tag;
    }

    public static final class Handler
    implements IMessageHandler<PacketSetRecipe, IMessage> {
        public IMessage onMessage(PacketSetRecipe message, MessageContext ctx) {
            AEBaseContainer aeContainer;
            IGrid grid;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container instanceof AEBaseContainer && (grid = message.getNetwork(aeContainer = (AEBaseContainer)container)) != null) {
                for (IGridNode gridNode : grid.getMachines(TilePatternInterface.class)) {
                    ItemStack patternStack;
                    ItemStack result;
                    if (!(gridNode.getMachine() instanceof TilePatternInterface)) continue;
                    TilePatternInterface tpi = (TilePatternInterface)gridNode.getMachine();
                    NBTTagCompound currentTag = message.recipe.func_74775_l("Outputs");
                    ItemStack itemStack = result = currentTag == null ? null : ItemStack.func_77949_a((NBTTagCompound)currentTag);
                    if (tpi.getProxy().isActive() && tpi.canPutPattern(result) && (patternStack = message.getPatternStack((EntityPlayer)player, message.recipe)) == null) continue;
                }
            }
            return null;
        }
    }
}

