/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.$AutoValue_Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_Layout_SlotGroupKey;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_Layout_SlotKey;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Lines;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Slot;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.SlotGroup;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Drawable;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class Layout
implements Drawable {
    public abstract ImmutableList<Lines> lines();

    public abstract ImmutableList<Drawable> labels();

    public abstract ImmutableList<Interactable> interactables();

    public abstract ImmutableMap<SlotKey, Slot> slots();

    public abstract ImmutableMap<SlotGroupKey, SlotGroup> slotGroups();

    public Optional<Slot> slot(SlotKey key) {
        return Optional.ofNullable(this.slots().get((Object)key));
    }

    public Optional<SlotGroup> slotGroup(SlotGroupKey key) {
        return Optional.ofNullable(this.slotGroups().get((Object)key));
    }

    public Iterable<Slot> allSlots() {
        ArrayList<ImmutableCollection> allSlots = new ArrayList<ImmutableCollection>(this.slotGroups().size() + 1);
        allSlots.add(this.slots().values());
        this.slotGroups().values().forEach(slotGroup -> allSlots.add((ImmutableCollection)slotGroup.slots()));
        return Iterables.concat(allSlots);
    }

    @Override
    public Dimension maxDimension() {
        return Drawable.computeMaxDimension(this.drawables());
    }

    @Override
    public void draw(DiagramState diagramState) {
        this.drawables().forEach(drawable -> drawable.draw(diagramState));
    }

    private Iterable<Drawable> drawables() {
        return Iterables.concat(this.lines(), (Iterable)this.slotGroups().values(), (Iterable)this.slots().values(), this.labels());
    }

    @ToPrettyString
    public abstract String toPrettyString();

    public static Builder builder() {
        return new $AutoValue_Layout.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setLines(Iterable<Lines> var1);

        public abstract ImmutableList.Builder<Lines> linesBuilder();

        public abstract Builder setLabels(Iterable<? extends Drawable> var1);

        public abstract ImmutableList.Builder<Drawable> labelsBuilder();

        public abstract Builder setInteractables(Iterable<? extends Interactable> var1);

        public abstract ImmutableList.Builder<Interactable> interactablesBuilder();

        public abstract Builder setSlots(Map<SlotKey, Slot> var1);

        public abstract ImmutableMap.Builder<SlotKey, Slot> slotsBuilder();

        public abstract Builder setSlotGroups(Map<SlotGroupKey, SlotGroup> var1);

        public abstract ImmutableMap.Builder<SlotGroupKey, SlotGroup> slotGroupsBuilder();

        public Builder addLines(Lines lines) {
            this.linesBuilder().add((Object)lines);
            return this;
        }

        public Builder addAllLines(Iterable<Lines> lines) {
            this.linesBuilder().addAll(lines);
            return this;
        }

        public Builder addLabel(Drawable label) {
            this.labelsBuilder().add((Object)label);
            return this;
        }

        public Builder addAllLabels(Iterable<? extends Drawable> labels) {
            this.labelsBuilder().addAll(labels);
            return this;
        }

        public Builder addInteractable(Interactable interactable) {
            this.interactablesBuilder().add((Object)interactable);
            return this;
        }

        public Builder addAllInteractables(Iterable<? extends Interactable> interactables) {
            this.interactablesBuilder().addAll(interactables);
            return this;
        }

        public Builder putSlot(SlotKey key, Slot slot) {
            this.slotsBuilder().put((Object)key, (Object)slot);
            return this;
        }

        public Builder putAllSlots(Map<SlotKey, Slot> slots) {
            this.slotsBuilder().putAll(slots);
            return this;
        }

        public Builder putSlotGroup(SlotGroupKey key, SlotGroup slotGroup) {
            this.slotGroupsBuilder().put((Object)key, (Object)slotGroup);
            return this;
        }

        public Builder putAllSlotGroups(Map<SlotGroupKey, SlotGroup> slotGroups) {
            this.slotGroupsBuilder().putAll(slotGroups);
            return this;
        }

        public Builder addSubLayout(Layout layout) {
            this.addAllLines((Iterable<Lines>)layout.lines());
            this.addAllLabels((Iterable<? extends Drawable>)layout.labels());
            this.addAllInteractables((Iterable<? extends Interactable>)layout.interactables());
            this.putAllSlots((Map<SlotKey, Slot>)layout.slots());
            this.putAllSlotGroups((Map<SlotGroupKey, SlotGroup>)layout.slotGroups());
            return this;
        }

        public abstract Layout build();
    }

    @AutoValue
    public static abstract class SlotGroupKey
    implements Key {
        public static SlotGroupKey create(String key) {
            return new AutoValue_Layout_SlotGroupKey(key);
        }

        @Override
        public abstract String key();
    }

    @AutoValue
    public static abstract class SlotKey
    implements Key {
        public static SlotKey create(String key) {
            return new AutoValue_Layout_SlotKey(key);
        }

        @Override
        public abstract String key();
    }

    public static interface Key {
        public String key();
    }
}

