/*
 * Decompiled with CFR 0.152.
 */
package xonin.backhand.client;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import invtweaks.InvTweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;
import xonin.backhand.CommonProxy;
import xonin.backhand.api.core.BackhandUtils;
import xonin.backhand.client.utils.BackhandRenderHelper;
import xonin.backhand.utils.BackhandConfig;
import xonin.backhand.utils.BackhandConfigClient;
import xonin.backhand.utils.Mods;

@EventBusSubscriber(side={Side.CLIENT})
public class ClientEventHandler {
    private static final ResourceLocation OFFHAND_SLOT_TEXTURE = new ResourceLocation("backhand", "textures/gui/offhand_slot.png");
    public static boolean prevInvTweaksAutoRefill;
    public static boolean prevInvTweaksBreakRefill;
    public static int invTweaksDelay;

    @SubscribeEvent(receiveCanceled=true)
    public static void renderHotbarOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ClientEventHandler.renderHotbar(event.resolution.func_78326_a(), event.resolution.func_78328_b(), event.partialTicks);
        }
    }

    @SubscribeEvent
    public static void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && CommonProxy.SWAP_KEY.isKeyDown((EntityPlayer)mc.field_71439_g)) {
            ClientEventHandler.invTweaksSwapPatch();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (invTweaksDelay > 0 && --invTweaksDelay == 0) {
            ClientEventHandler.restoreInvTweaksConfigs();
        }
    }

    private static void renderHotbar(int width, int height, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack itemstack = BackhandUtils.getOffhandItem((EntityPlayer)mc.field_71439_g);
        if (itemstack == null && !BackhandConfigClient.RenderOffhandHotbarSlotWhenEmpty) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.field_71446_o.func_110577_a(OFFHAND_SLOT_TEXTURE);
        int offsetX = (Mods.DOUBLE_WIDE_SURPRISE.isLoaded() ? 212 : 125) - BackhandConfigClient.offhandHotbarSlotXOffset;
        int offsetY = BackhandConfigClient.offhandHotbarSlotYOffset;
        ClientEventHandler.renderTexture(width / 2 - offsetX, height - 22 - offsetY, -90, 22, 22);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        int x = width / 2 - offsetX + 3;
        int z = height - 16 - 3 - offsetY;
        ClientEventHandler.renderOffhandInventorySlot(x, z, partialTicks);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    private static void renderOffhandInventorySlot(int p_73832_2_, int p_73832_3_, float p_73832_4_) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack itemstack = BackhandUtils.getOffhandItem((EntityPlayer)mc.field_71439_g);
        if (itemstack != null) {
            float f1 = (float)itemstack.field_77992_b - p_73832_4_;
            if (f1 > 0.0f) {
                GL11.glPushMatrix();
                float f2 = 1.0f + f1 / 5.0f;
                GL11.glTranslatef((float)(p_73832_2_ + 8), (float)(p_73832_3_ + 12), (float)0.0f);
                GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(p_73832_2_ + 8)), (float)(-(p_73832_3_ + 12)), (float)0.0f);
            }
            RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.func_110434_K(), itemstack, p_73832_2_, p_73832_3_);
            if (f1 > 0.0f) {
                GL11.glPopMatrix();
            }
            RenderItem.getInstance().func_77021_b(mc.field_71466_p, mc.func_110434_K(), itemstack, p_73832_2_, p_73832_3_);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderPlayerLeftItemUsage(RenderLivingEvent.Pre event) {
        RendererLivingEntity rendererLivingEntity;
        EntityPlayer entityPlayer;
        ItemStack offhand;
        EntityLivingBase entityLivingBase = event.entity;
        if (entityLivingBase instanceof EntityPlayer && (offhand = BackhandUtils.getOffhandItem(entityPlayer = (EntityPlayer)entityLivingBase)) != null && (rendererLivingEntity = event.renderer) instanceof RenderPlayer) {
            RenderPlayer renderer = (RenderPlayer)rendererLivingEntity;
            if (renderer.field_77109_a.field_78119_l < 1) {
                renderer.field_77109_a.field_78119_l = 1;
                renderer.field_77111_i.field_78119_l = 1;
                renderer.field_77108_b.field_78119_l = 1;
            }
            if (entityPlayer.func_71052_bv() > 0 && entityPlayer.func_71011_bu() == offhand) {
                EnumAction enumaction = offhand.func_77975_n();
                if (enumaction == EnumAction.block) {
                    renderer.field_77109_a.field_78119_l = 3;
                    renderer.field_77111_i.field_78119_l = 3;
                    renderer.field_77108_b.field_78119_l = 3;
                } else if (enumaction == EnumAction.bow) {
                    renderer.field_77109_a.field_78118_o = true;
                    renderer.field_77111_i.field_78118_o = true;
                    renderer.field_77108_b.field_78118_o = true;
                }
                ItemStack mainhand = entityPlayer.field_71071_by.func_70448_g();
                renderer.field_77109_a.field_78120_m = mainhand != null ? 1 : 0;
                renderer.field_77111_i.field_78120_m = renderer.field_77109_a.field_78120_m;
                renderer.field_77108_b.field_78120_m = renderer.field_77109_a.field_78120_m;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void resetPlayerLeftHand(RenderPlayerEvent.Post event) {
        event.renderer.field_77109_a.field_78119_l = 0;
        event.renderer.field_77111_i.field_78119_l = 0;
        event.renderer.field_77108_b.field_78119_l = 0;
    }

    @SubscribeEvent
    public static void render3rdPersonOffhand(RenderPlayerEvent.Specials.Post event) {
        if (!BackhandConfig.EmptyOffhand && BackhandUtils.getOffhandItem(event.entityPlayer) == null) {
            return;
        }
        GL11.glPushMatrix();
        ModelBiped biped = event.renderer.field_77109_a;
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2884);
        BackhandRenderHelper.renderOffhandItemIn3rdPerson(event.entityPlayer, biped, event.partialRenderTick);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    public static void restoreInvTweaksConfigs() {
        if (!Mods.INV_TWEAKS.isLoaded()) {
            return;
        }
        InvTweaks.getConfigManager().getConfig().setProperty("enableAutoRefill", String.valueOf(prevInvTweaksAutoRefill));
        InvTweaks.getConfigManager().getConfig().setProperty("autoRefillBeforeBreak", String.valueOf(prevInvTweaksBreakRefill));
    }

    public static void invTweaksSwapPatch() {
        if (!Mods.INV_TWEAKS.isLoaded()) {
            return;
        }
        if (invTweaksDelay <= 0) {
            prevInvTweaksAutoRefill = Boolean.parseBoolean(InvTweaks.getConfigManager().getConfig().getProperty("enableAutoRefill"));
            prevInvTweaksBreakRefill = Boolean.parseBoolean(InvTweaks.getConfigManager().getConfig().getProperty("autoRefillBeforeBreak"));
            InvTweaks.getConfigManager().getConfig().setProperty("enableAutoRefill", "false");
            InvTweaks.getConfigManager().getConfig().setProperty("autoRefillBeforeBreak", "false");
        }
        invTweaksDelay = 15;
    }

    private static void renderTexture(int x, int y, int zLevel, int width, int height) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), (double)zLevel, 0.0, 1.0);
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, 1.0, 1.0);
        tess.func_78374_a((double)(x + width), (double)y, (double)zLevel, 1.0, 0.0);
        tess.func_78374_a((double)x, (double)y, (double)zLevel, 0.0, 0.0);
        tess.func_78381_a();
    }
}

