/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.INamedArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.IPositionalArgumentHandler;
import dev.rndmorris.salisarcana.lib.ArrayHelper;
import dev.rndmorris.salisarcana.lib.IntegerHelper;
import dev.rndmorris.salisarcana.lib.KnowItAll;
import dev.rndmorris.salisarcana.lib.WandFocusHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;

public class FocusUpgradesHandler
implements INamedArgumentHandler,
IPositionalArgumentHandler {
    public static final FocusUpgradesHandler INSTANCE = new FocusUpgradesHandler();
    private final Map<Short, String> upgradeKeyCache = new TreeMap<Short, String>();

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        ArrayList<FocusUpgradeType> resultList = new ArrayList<FocusUpgradeType>(5);
        String peeked = null;
        while (args.hasNext() && (peeked = (String)args.peek()) != null && !peeked.startsWith("-")) {
            String key = (String)args.next();
            FocusUpgradeType upgrade = this.getUpgradeFromKey(key);
            if (upgrade == null) {
                throw new CommandException("salisarcana:error.invalid_focus_upgrade", new Object[]{key});
            }
            resultList.add(upgrade);
        }
        return resultList;
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        ItemFocusBasic heldFocus;
        EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
        ItemStack heldItem = player.func_71045_bC();
        if (heldItem == null || (heldFocus = WandFocusHelper.getFocusFrom(heldItem)) == null) {
            return Arrays.stream(FocusUpgradeType.types).map(this::formatUpgradeKey).collect(Collectors.toList());
        }
        ItemStack workingItem = heldItem.func_77946_l();
        List<FocusUpgradeType> appliedUpgrades = WandFocusHelper.getAppliedUpgrades(heldFocus, workingItem);
        if (appliedUpgrades.size() >= 5) {
            return null;
        }
        String peeked = null;
        while (appliedUpgrades.size() < 5 && args.hasNext() && (peeked = (String)args.peek()) != null && !peeked.startsWith("-")) {
            String key = (String)args.next();
            FocusUpgradeType upgrade = this.getUpgradeFromKey(key);
            if (upgrade == null) continue;
            appliedUpgrades.add(upgrade);
            heldFocus.applyUpgrade(workingItem, upgrade, appliedUpgrades.size());
        }
        if (peeked != null && peeked.startsWith("-")) {
            return null;
        }
        FocusUpgradeType[] possibleUpgrades = heldFocus.getPossibleUpgradesByRank(heldItem, appliedUpgrades.size() + 1);
        if (possibleUpgrades == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(possibleUpgrades.length);
        for (FocusUpgradeType upgrade : possibleUpgrades) {
            if (!heldFocus.canApplyUpgrade(workingItem, (EntityPlayer)KnowItAll.getInstance(), upgrade, appliedUpgrades.size() + 1)) continue;
            result.add(this.formatUpgradeKey(upgrade));
        }
        return result;
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return List.class;
    }

    @Nonnull
    private String formatUpgradeKey(@Nonnull FocusUpgradeType focusUpgrade) {
        return this.upgradeKeyCache.computeIfAbsent(focusUpgrade.id, id -> {
            String cleanedName = focusUpgrade.getLocalizedName().toLowerCase().replaceAll(" +", "-").replaceAll("[^\\w-]", "");
            return String.format("%s-%d", cleanedName, focusUpgrade.id);
        });
    }

    @Nullable
    private FocusUpgradeType getUpgradeFromKey(@Nonnull String key) {
        String[] keyParts = key.split("-");
        if (keyParts.length < 1) {
            return null;
        }
        Integer upgradeId = IntegerHelper.tryParse(keyParts[keyParts.length - 1]);
        if (upgradeId == null) {
            return null;
        }
        return ArrayHelper.tryGet(FocusUpgradeType.types, upgradeId).data();
    }
}

