/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.textures;

import gcewing.sg.interfaces.ITexture;
import gcewing.sg.interfaces.ITiledTexture;
import gcewing.sg.textures.Proxy;
import gcewing.sg.textures.Sprite;
import gcewing.sg.textures.TileSet;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public abstract class BaseTexture
implements ITexture {
    public ResourceLocation location;
    public int tintIndex;
    public double red = 1.0;
    public double green = 1.0;
    public double blue = 1.0;
    public boolean isEmissive;
    public boolean isProjected;

    @Override
    public int tintIndex() {
        return this.tintIndex;
    }

    @Override
    public double red() {
        return this.red;
    }

    @Override
    public double green() {
        return this.green;
    }

    @Override
    public double blue() {
        return this.blue;
    }

    @Override
    public boolean isEmissive() {
        return this.isEmissive;
    }

    @Override
    public boolean isProjected() {
        return this.isProjected;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    public static Sprite fromSprite(IIcon icon) {
        return new Sprite(icon);
    }

    @Override
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    public ITexture colored(double red, double green, double blue) {
        Proxy result = new Proxy(this);
        result.red = red;
        result.green = green;
        result.blue = blue;
        return result;
    }

    @Override
    public ITexture emissive() {
        Proxy result = new Proxy(this);
        result.isEmissive = true;
        return result;
    }

    @Override
    public ITexture projected() {
        Proxy result = new Proxy(this);
        result.isProjected = true;
        return result;
    }

    @Override
    public ITiledTexture tiled(int numRows, int numCols) {
        return new TileSet(this, numRows, numCols);
    }
}

