/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.tcwands.api.wrappers;

import com.gtnewhorizons.tcwands.api.WandType;
import com.gtnewhorizons.tcwands.api.wandinfo.WandDetails;
import com.gtnewhorizons.tcwands.api.wandinfo.WandProps;
import com.gtnewhorizons.tcwands.api.wrappers.AbstractWandWrapper;
import com.gtnewhorizons.tcwands.api.wrappers.CapWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import thaumcraft.common.config.ConfigItems;

public class SceptreWrapper
extends AbstractWandWrapper {
    private float sceptreCostMultiplier;

    public SceptreWrapper(WandDetails wandDetails, WandProps wandProps, float sceptreCostMultiplier) {
        super(wandDetails, wandProps);
        this.sceptreCostMultiplier = sceptreCostMultiplier;
    }

    public float getSceptreCostMultiplier() {
        return this.sceptreCostMultiplier;
    }

    @Override
    protected NBTTagCompound writeNBT(CapWrapper cap) {
        NBTTagCompound wandNbt = super.writeNBT(cap);
        wandNbt.func_74774_a("sceptre", (byte)1);
        return wandNbt;
    }

    @Override
    public int getRecipeCost(CapWrapper cap) {
        return (int)((float)super.getRecipeCost(cap) * this.sceptreCostMultiplier);
    }

    @Override
    public Object[] genRecipe(CapWrapper cap) {
        return new Object[]{"MCP", "SRC", "CSM", Character.valueOf('R'), this.getCraftingRod(), Character.valueOf('M'), this.getDetails().getConductor(), Character.valueOf('S'), this.getDetails().getScrew(), Character.valueOf('C'), cap.getItem(), Character.valueOf('P'), new ItemStack(ConfigItems.itemResource, 1, 15)};
    }

    @Override
    public String getDefaultResearchName() {
        return "SCEPTRE";
    }

    @Override
    @NotNull
    public WandType getType() {
        return WandType.SCEPTRE;
    }
}

