/*
 * Decompiled with CFR 0.152.
 */
package journeymap.shadow.io.javalin.core.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import journeymap.shadow.kotlin.Metadata;
import journeymap.shadow.kotlin.io.FilesKt;
import journeymap.shadow.kotlin.io.TextStreamsKt;
import journeymap.shadow.kotlin.jvm.JvmStatic;
import journeymap.shadow.kotlin.jvm.internal.Intrinsics;
import journeymap.shadow.kotlin.text.Charsets;
import journeymap.shadow.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Ljourneymap/shadow/io/javalin/core/util/FileUtil;", "", "()V", "readFile", "", "path", "readResource", "streamToFile", "", "inputStream", "Ljava/io/InputStream;", "javalin"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    @JvmStatic
    public static final void streamToFile(@NotNull InputStream inputStream, @NotNull String path) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(path, "path");
        File newFile = new File(path);
        newFile.getParentFile().mkdirs();
        newFile.createNewFile();
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(inputStream, newFile.toPath(), copyOptionArray);
    }

    @JvmStatic
    @NotNull
    public static final String readResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        URL uRL = FileUtil.class.getResource(path);
        Intrinsics.checkNotNullExpressionValue(uRL, "FileUtil::class.java.getResource(path)");
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = TextStreamsKt.readBytes(uRL);
        boolean bl2 = false;
        boolean bl3 = false;
        return new String(byArray, charset);
    }

    @JvmStatic
    @NotNull
    public static final String readFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return FilesKt.readText$default(new File(path), null, 1, null);
    }
}

