/*
 * Decompiled with CFR 0.152.
 */
package emt.item.focus;

import emt.entity.EntityEnergyBall;
import emt.item.focus.ItemBaseFocus;
import ic2.api.item.ElectricItem;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.wands.FocusUpgradeType;

public class ItemEnergyBallFocus
extends ItemBaseFocus {
    public ItemEnergyBallFocus() {
        super("energyBall");
    }

    public int getFocusColor(ItemStack stack) {
        return 255;
    }

    public String getSortingHelper(ItemStack itemstack) {
        return "ENERGYBALL" + super.getSortingHelper(itemstack);
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        return new FocusUpgradeType[]{FocusUpgradeType.frugal};
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        if (world.field_72995_K) {
            return stack;
        }
        ItemStack armor = player.field_71071_by.field_70460_b[2];
        if (armor == null) {
            return stack;
        }
        int cost = this.getCost(stack);
        double val = ElectricItem.manager.discharge(armor, (double)cost, 4, true, false, false);
        if (val < (double)cost) {
            return stack;
        }
        float rotX = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * 100.0f;
        float rotY = -MathHelper.func_76126_a((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * 100.0f;
        float rotZ = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * 100.0f;
        world.func_72838_d((Entity)new EntityEnergyBall(world, (EntityLivingBase)player, rotX, rotY, rotZ));
        return stack;
    }

    private int getCost(ItemStack stack) {
        return (int)(5120.0 * (1.0 - 0.1 * (double)this.getUpgradeLevel(stack, FocusUpgradeType.frugal)));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"item.EMT.focus.EU.cost.info"));
        list.add(StatCollector.func_74837_a((String)"item.EMT.focus.EU.cost.once", (Object[])new Object[]{this.getCost(stack)}));
        this.addFocusInformation(stack, player, list, par4);
    }
}

