/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen.pyramid;

import de.katzenpapst.amunra.world.mapgen.populator.FillChest;
import de.katzenpapst.amunra.world.mapgen.populator.SetSpawnerEntity;
import de.katzenpapst.amunra.world.mapgen.pyramid.Pyramid;
import de.katzenpapst.amunra.world.mapgen.pyramid.PyramidRoom;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class ChestRoom
extends PyramidRoom {
    protected BlockMetaPair chest = new BlockMetaPair((Block)Blocks.field_150486_ae, 0);
    protected BlockMetaPair spawner = new BlockMetaPair(Blocks.field_150474_ac, 0);

    @Override
    public boolean generateChunk(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        super.generateChunk(chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        this.generateBoxWithChest(this.roomBB.field_78897_a + 5, this.roomBB.field_78896_c + 5, chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        this.generateBoxWithChest(this.roomBB.field_78897_a + 5, this.roomBB.field_78892_f - 5, chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        this.generateBoxWithChest(this.roomBB.field_78893_d - 5, this.roomBB.field_78896_c + 5, chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        this.generateBoxWithChest(this.roomBB.field_78893_d - 5, this.roomBB.field_78892_f - 5, chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
        return true;
    }

    protected void generateBoxWithChest(int centerX, int centerZ, int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        int startY = this.floorLevel;
        int stopY = this.roomBB.field_78894_e;
        BlockMetaPair floorMat = ((Pyramid)this.parent).getFloorMaterial();
        for (int x = centerX - 1; x <= centerX + 1; ++x) {
            for (int z = centerZ - 1; z <= centerZ + 1; ++z) {
                for (int y = startY; y <= stopY; ++y) {
                    if (y == startY || y == stopY || x != centerX && z != centerZ) {
                        ChestRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, floorMat);
                        continue;
                    }
                    if (x == centerX && z == centerZ) {
                        if (y == startY + 1) {
                            this.placeChest("amunraPyramidChest", x, y, z, chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
                            continue;
                        }
                        if (y == startY + 2) {
                            this.placeSpawner(ChestRoom.getMob(this.parent.getWorld().field_73012_v), x, y, z, chunkX, chunkZ, arrayOfIDs, arrayOfMeta);
                            continue;
                        }
                        ChestRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, floorMat);
                        continue;
                    }
                    ChestRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, Blocks.field_150411_aY, 0);
                }
            }
        }
    }

    protected void placeChest(String lootCat, int x, int y, int z, int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        if (ChestRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, this.chest)) {
            this.parent.addPopulator(new FillChest(x, y, z, this.chest, lootCat));
        }
    }

    protected void placeSpawner(String entityName, int x, int y, int z, int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        if (ChestRoom.placeBlockAbs(arrayOfIDs, arrayOfMeta, x, y, z, chunkX, chunkZ, this.spawner)) {
            this.parent.addPopulator(new SetSpawnerEntity(x, y, z, entityName));
        }
    }

    private static String getMob(Random rand) {
        String string;
        switch (rand.nextInt(6)) {
            case 0: {
                string = "EvolvedSpider";
                break;
            }
            case 1: {
                string = "EvolvedZombie";
                break;
            }
            case 2: {
                string = "EvolvedCreeper";
                break;
            }
            case 3: {
                string = "EvolvedSkeleton";
                break;
            }
            default: {
                string = "EvolvedCreeper";
            }
        }
        return string;
    }
}

