/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.api.DisplaySettingHelper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.items.ItemUpgrade;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;
import shedar.mods.ic2.nuclearcontrol.utils.DataSorter;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

public class TileEntityAdvancedInfoPanel
extends TileEntityInfoPanel {
    private static final byte SLOT_CARD1 = 0;
    private static final byte SLOT_CARD2 = 1;
    private static final byte SLOT_CARD3 = 2;
    private static final byte SLOT_UPGRADE_RANGE = 3;
    private static final byte SLOT_UPGRADE_WEB = 3;
    public static final int POWER_REDSTONE = 0;
    public static final int POWER_INVERTED = 1;
    public static final int POWER_ON = 2;
    public static final int POWER_OFF = 3;
    public static final int TRANSPARENCY_CHANGED = 6;
    public static final int ROTATE_LEFT = 7;
    public static final int ROTATE_RIGHT = 8;
    public static final int OFFSET_THICKNESS = 100;
    public static final int OFFSET_ROTATE_HOR = 200;
    public static final int OFFSET_ROTATE_VERT = 300;
    public byte powerMode;
    public byte transparencyMode;
    public byte thickness;
    public byte rotateHor;
    public byte rotateVert;
    public byte textRotation;
    private byte prevPowerMode;
    private byte prevtransparencyMode;
    private byte prevThickness;
    private byte prevRotateHor;
    private byte prevRotateVert;
    private byte prevTextRotation;
    public ItemStack card2;
    public ItemStack card3;
    protected final Map<Byte, Map<UUID, DataSorter>> dataSorters = new HashMap<Byte, Map<UUID, DataSorter>>();

    public TileEntityAdvancedInfoPanel() {
        super(4);
        this.colored = true;
        this.thickness = (byte)16;
    }

    @Override
    public int getCardSlotsCount() {
        return 3;
    }

    @Override
    public List<ItemStack> getCards() {
        ArrayList<ItemStack> data = new ArrayList<ItemStack>(3);
        data.add(this.inventory[0]);
        data.add(this.inventory[1]);
        data.add(this.inventory[2]);
        return data;
    }

    @Override
    protected boolean isCardSlot(int slot) {
        return slot == 0 || slot == 1 || slot == 2;
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemstack) {
        switch (slotIndex) {
            case 0: 
            case 1: 
            case 2: {
                return itemstack.func_77973_b() instanceof IPanelDataSource;
            }
            case 3: {
                return itemstack.func_77973_b() instanceof ItemUpgrade && (itemstack.func_77960_j() == 0 || itemstack.func_77960_j() == 2);
            }
        }
        return false;
    }

    @Override
    protected ItemStack getRangeUpgrade() {
        return this.inventory[3];
    }

    @Override
    protected boolean isWebEval() {
        ItemStack itemStack = this.inventory[3];
        return itemStack != null && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 2;
    }

    public byte getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(byte p) {
        this.powerMode = p;
        if (this.prevPowerMode != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "powerMode");
        }
        this.prevPowerMode = this.powerMode;
    }

    public byte getTransparencyMode() {
        return this.transparencyMode;
    }

    public void setTransparencyMode(byte b) {
        if (b == 2) {
            b = 0;
        }
        this.transparencyMode = b;
        if (this.prevtransparencyMode != b) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "transparencyMode");
        }
        this.prevtransparencyMode = this.transparencyMode;
    }

    public void setThickness(byte p) {
        this.thickness = p;
        if (this.prevThickness != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "thickness");
        }
        this.prevThickness = this.thickness;
    }

    public byte getThickness() {
        return this.thickness;
    }

    public void setRotateHor(byte p) {
        this.rotateHor = p;
        if (this.prevRotateHor != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotateHor");
        }
        this.prevRotateHor = this.rotateHor;
    }

    public byte getRotationHor() {
        return this.rotateHor;
    }

    public void setRotateVert(byte p) {
        this.rotateVert = p;
        if (this.prevRotateVert != p) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotateVert");
        }
        this.prevRotateVert = this.rotateVert;
    }

    public byte getRotationVert() {
        return this.rotateVert;
    }

    @Override
    public byte getTextRotation() {
        return this.textRotation;
    }

    public void setTextRotation(byte r) {
        if (r == -1) {
            r = (byte)3;
        } else if (r == 4) {
            r = 0;
        }
        this.textRotation = r;
        if (this.prevTextRotation != r) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "textRotation");
        }
        this.prevTextRotation = this.textRotation;
    }

    public byte getNextPowerMode() {
        switch (this.powerMode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean getPowered() {
        switch (this.powerMode) {
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 0: {
                return this.powered;
            }
            case 1: {
                return !this.powered;
            }
        }
        return false;
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> list = super.getNetworkedFields();
        list.add("card2");
        list.add("card3");
        list.add("powerMode");
        list.add("transparencyMode");
        list.add("thickness");
        list.add("rotateHor");
        list.add("rotateVert");
        list.add("textRotation");
        return list;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("card2")) {
            this.inventory[1] = this.card2;
        } else if (field.equals("card3")) {
            this.inventory[2] = this.card3;
        } else if (field.equals("powerMode") && this.prevPowerMode != this.powerMode) {
            if (this.screen != null) {
                this.screen.turnPower(this.getPowered(), this.field_145850_b);
            } else {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.prevPowerMode = this.powerMode;
        } else if (field.equals("thickness") || field.equals("rotateHor") || field.equals("rotateVert") || field.equals("textRotation") || field.equals("transparencyMode")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (field.equals("transparencyMode")) {
                this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    protected void initData() {
        super.initData();
        NuclearNetworkHelper.requestDataSorters(this);
    }

    @Override
    public void onNetworkEvent(EntityPlayer entityplayer, int i) {
        super.onNetworkEvent(entityplayer, i);
        if (i >= 0 && i < 100) {
            switch (i) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.setPowerMode((byte)i);
                    break;
                }
                case 6: {
                    this.setTransparencyMode((byte)(this.getTransparencyMode() + 1));
                    break;
                }
                case 7: {
                    this.setTextRotation((byte)(this.textRotation - 1));
                    break;
                }
                case 8: {
                    this.setTextRotation((byte)(this.textRotation + 1));
                }
            }
        } else if (i >= 100 && i < 200) {
            this.setThickness((byte)(i - 100));
        } else if (i >= 200 && i < 300) {
            this.setRotateHor((byte)(-((i -= 208) * 7)));
        } else if (i >= 300 && i < 400) {
            this.setRotateVert((byte)(-((i -= 308) * 7)));
        }
    }

    @Override
    protected void saveDisplaySettings(NBTTagCompound nbt) {
        nbt.func_74782_a("dSettings1", (NBTBase)this.serializeSlotSettings((byte)0));
        nbt.func_74782_a("dSettings2", (NBTBase)this.serializeSlotSettings((byte)1));
        nbt.func_74782_a("dSettings3", (NBTBase)this.serializeSlotSettings((byte)2));
        nbt.func_74774_a("rotateHor", this.rotateHor);
        nbt.func_74774_a("rotateVert", this.rotateVert);
        nbt.func_74774_a("thickness", this.thickness);
        nbt.func_74774_a("powerMode", this.powerMode);
        nbt.func_74774_a("transparencyMode", this.transparencyMode);
        nbt.func_74774_a("textRotation", this.textRotation);
    }

    @Override
    protected void readDisplaySettings(NBTTagCompound nbt) {
        this.deserializeDisplaySettings(nbt, "dSettings1", (byte)0);
        this.deserializeDisplaySettings(nbt, "dSettings2", (byte)1);
        this.deserializeDisplaySettings(nbt, "dSettings3", (byte)2);
        this.rotateHor = nbt.func_74771_c("rotateHor");
        this.rotateVert = nbt.func_74771_c("rotateVert");
        this.thickness = nbt.func_74771_c("thickness");
        this.powerMode = nbt.func_74771_c("powerMode");
        this.transparencyMode = nbt.func_74771_c("transparencyMode");
        this.textRotation = nbt.func_74771_c("textRotation");
    }

    @Override
    public void readDisplaySettingsFromCard(ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        this.setDeserializedDisplaySettings(nbt, "dSettings1", (byte)0);
        this.setDeserializedDisplaySettings(nbt, "dSettings2", (byte)1);
        this.setDeserializedDisplaySettings(nbt, "dSettings3", (byte)2);
        this.setDeserializedDisplaySettings(nbt, "dSettings", (byte)0);
        if (nbt.func_74764_b("rotateHor")) {
            this.setRotateHor(nbt.func_74771_c("rotateHor"));
            this.setRotateVert(nbt.func_74771_c("rotateVert"));
            this.setThickness(nbt.func_74771_c("thickness"));
            this.setPowerMode(nbt.func_74771_c("powerMode"));
            this.setTransparencyMode(nbt.func_74771_c("transparencyMode"));
            this.setTextRotation(nbt.func_74771_c("textRotation"));
            this.setColorText(nbt.func_74762_e("colorText"));
            this.setColorBackground(nbt.func_74762_e("colorBackground"));
        }
    }

    @Override
    protected void postReadFromNBT() {
        if (this.inventory[0] != null) {
            this.card = this.inventory[0];
        }
        if (this.inventory[1] != null) {
            this.card2 = this.inventory[1];
        }
        if (this.inventory[2] != null) {
            this.card3 = this.inventory[2];
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeDataSortersToNBT(nbt);
    }

    private NBTTagList getDataSorterForSlot(byte slot) {
        NBTTagList settingsList = new NBTTagList();
        if (this.dataSorters.containsKey(slot)) {
            for (Map.Entry<UUID, DataSorter> item : this.dataSorters.get(slot).entrySet()) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("key", item.getKey().toString());
                compound.func_74783_a("value", item.getValue().getArray());
                settingsList.func_74742_a((NBTBase)compound);
            }
        }
        return settingsList;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readDataSortersFromNBT(nbt);
    }

    public void writeDataSortersToNBT(NBTTagCompound nbt) {
        NBTTagCompound settingsList = new NBTTagCompound();
        settingsList.func_74782_a(String.valueOf(0), (NBTBase)this.getDataSorterForSlot((byte)0));
        settingsList.func_74782_a(String.valueOf(1), (NBTBase)this.getDataSorterForSlot((byte)1));
        settingsList.func_74782_a(String.valueOf(2), (NBTBase)this.getDataSorterForSlot((byte)2));
        nbt.func_74782_a("dataSorters", (NBTBase)settingsList);
    }

    public void readDataSortersFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("dataSorters")) {
            NBTTagCompound settingsList = nbt.func_74775_l("dataSorters");
            this.dataSorters.put((byte)0, this.deserializeDataSorter(settingsList.func_150295_c(String.valueOf(0), 10)));
            this.dataSorters.put((byte)1, this.deserializeDataSorter(settingsList.func_150295_c(String.valueOf(1), 10)));
            this.dataSorters.put((byte)2, this.deserializeDataSorter(settingsList.func_150295_c(String.valueOf(2), 10)));
        }
    }

    private Map<UUID, DataSorter> deserializeDataSorter(NBTTagList dataSorters) {
        HashMap<UUID, DataSorter> rv = new HashMap<UUID, DataSorter>();
        for (int i = 0; i < dataSorters.func_74745_c(); ++i) {
            NBTTagCompound compound = dataSorters.func_150305_b(i);
            rv.put(UUID.fromString(compound.func_74779_i("key")), new DataSorter(compound.func_74759_k("value")));
        }
        return rv;
    }

    public List<PanelString> getSortedCardData(DisplaySettingHelper settings, ItemStack cardStack, CardWrapperImpl helper) {
        ArrayList<PanelString> data = new ArrayList<PanelString>(this.getCardData(settings, cardStack, helper));
        ArrayList<PanelString> all_data = new ArrayList<PanelString>(this.getCardData(new DisplaySettingHelper(true), cardStack, helper));
        if (!Objects.equals(helper.getTitle(), "")) {
            PanelString title = (PanelString)data.remove(0);
            all_data.remove(0);
            this.getDataSorter(this.getIndexOfCard(cardStack)).sortListByPrefix(data, all_data);
            data.add(0, title);
        } else {
            this.getDataSorter(this.getIndexOfCard(cardStack)).sortListByPrefix(data, all_data);
        }
        return data;
    }

    @Override
    protected boolean isColoredEval() {
        return true;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 9);
    }

    public Map<Byte, Map<UUID, DataSorter>> getDataSorters() {
        if (this.dataSorters == null) {
            return new HashMap<Byte, Map<UUID, DataSorter>>();
        }
        return this.dataSorters;
    }

    public DataSorter getDataSorter(byte slot) {
        UUID uuid = ((IPanelDataSource)this.func_70301_a(slot).func_77973_b()).getCardType();
        if (this.dataSorters.containsKey(slot)) {
            if (!this.dataSorters.get(slot).containsKey(uuid)) {
                this.dataSorters.get(slot).put(uuid, new DataSorter());
            }
        } else {
            HashMap<UUID, DataSorter> newMap = new HashMap<UUID, DataSorter>();
            newMap.put(uuid, new DataSorter());
            this.dataSorters.put(slot, newMap);
        }
        return this.dataSorters.get(slot).get(uuid);
    }

    public void setDataSorter(byte slot, DataSorter sorter, boolean sendToServer) {
        UUID uuid = ((IPanelDataSource)this.func_70301_a(slot).func_77973_b()).getCardType();
        if (!this.dataSorters.containsKey(slot)) {
            HashMap<UUID, DataSorter> newMap = new HashMap<UUID, DataSorter>();
            newMap.put(uuid, sorter);
            this.dataSorters.put(slot, newMap);
        } else {
            this.dataSorters.get(slot).put(uuid, sorter);
        }
        if (sendToServer) {
            NuclearNetworkHelper.sendDataSorterSync(this);
        }
    }
}

