/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.arboriculture.blocks.BlockFruitPod;
import forestry.arboriculture.genetics.ArboristTracker;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.genetics.SpeciesRoot;
import forestry.core.utils.BlockUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class TreeHelper
extends SpeciesRoot
implements ITreeRoot {
    public static final String UID = "rootTrees";
    private static int treeSpeciesCount = -1;
    private static ITreekeepingMode activeTreekeepingMode;
    public static final ArrayList<ITree> treeTemplates;
    private final ArrayList<ITreekeepingMode> treekeepingModes = new ArrayList();
    private static final List<ITreeMutation> treeMutations;
    private final LinkedList<ILeafTickHandler> leafTickHandlers = new LinkedList();

    public TreeHelper() {
        this.setResearchSuitability(new ItemStack(Blocks.field_150345_g, 1, Short.MAX_VALUE), 1.0f);
    }

    @Override
    public String getUID() {
        return UID;
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return ITree.class;
    }

    @Override
    public int getSpeciesCount() {
        if (treeSpeciesCount < 0) {
            treeSpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleTreeSpecies) || !((IAlleleTreeSpecies)entry.getValue()).isCounted()) continue;
                ++treeSpeciesCount;
            }
        }
        return treeSpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack itemstack) {
        return this.getType(itemstack) != EnumGermlingType.NONE;
    }

    @Override
    public boolean isMember(ItemStack stack, int type) {
        return this.getType(stack).ordinal() == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof ITree;
    }

    @Override
    public EnumGermlingType getType(ItemStack stack) {
        if (stack == null) {
            return EnumGermlingType.NONE;
        }
        Item item = stack.func_77973_b();
        if (PluginArboriculture.items.sapling == item) {
            return EnumGermlingType.SAPLING;
        }
        if (PluginArboriculture.items.pollenFertile == item) {
            return EnumGermlingType.POLLEN;
        }
        return EnumGermlingType.NONE;
    }

    @Override
    public ITree getTree(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileSapling)) {
            return null;
        }
        return ((TileSapling)tile).getTree();
    }

    @Override
    public ITree getMember(ItemStack itemstack) {
        if (!this.isMember(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    public ITree getMember(NBTTagCompound compound) {
        return new Tree(compound);
    }

    @Override
    public ITree getTree(World world, ITreeGenome genome) {
        return new Tree(genome);
    }

    @Override
    public ItemStack getMemberStack(IIndividual tree, int type) {
        ItemGermlingGE germlingItem;
        if (!this.isMember(tree)) {
            return null;
        }
        switch (EnumGermlingType.VALUES[type]) {
            case SAPLING: {
                germlingItem = PluginArboriculture.items.sapling;
                break;
            }
            case POLLEN: {
                germlingItem = PluginArboriculture.items.pollenFertile;
                break;
            }
            default: {
                throw new RuntimeException("Cannot instantiate a tree of type " + type);
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        tree.writeToNBT(nbttagcompound);
        ItemStack treeStack = new ItemStack((Item)germlingItem);
        treeStack.func_77982_d(nbttagcompound);
        return treeStack;
    }

    @Override
    public boolean plantSapling(World world, ITree tree, GameProfile owner, int x, int y, int z) {
        boolean placed = world.func_147465_d(x, y, z, (Block)PluginArboriculture.blocks.saplingGE, 0, 3);
        if (!placed) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (PluginArboriculture.blocks.saplingGE != block) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileSapling)) {
            world.func_147468_f(x, y, z);
            return false;
        }
        TileSapling sapling = (TileSapling)tile;
        sapling.setTree(tree.copy());
        sapling.setOwner(owner);
        return true;
    }

    @Override
    public boolean setFruitBlock(World world, IAlleleFruit allele, float sappiness, short[] indices, int x, int y, int z) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        boolean placed = world.func_147465_d(x, y, z, (Block)PluginArboriculture.blocks.pods, direction, 3);
        if (!placed) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (PluginArboriculture.blocks.pods != block) {
            return false;
        }
        TileFruitPod pod = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (pod == null) {
            world.func_147468_f(x, y, z);
            return false;
        }
        pod.setFruit(allele, sappiness, indices);
        world.func_147471_g(x, y, z);
        return true;
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public ITree templateAsIndividual(IAllele[] template) {
        return new Tree(this.templateAsGenome(template));
    }

    @Override
    public ITree templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Tree(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public IArboristTracker getBreedingTracker(World world, GameProfile player) {
        String filename = "ArboristTracker." + (player == null ? "common" : player.getId());
        ArboristTracker tracker = (ArboristTracker)world.func_72943_a(ArboristTracker.class, filename);
        if (tracker == null) {
            tracker = new ArboristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        tracker.setUsername(player);
        tracker.setWorld(world);
        return tracker;
    }

    @Override
    public ArrayList<ITreekeepingMode> getTreekeepingModes() {
        return this.treekeepingModes;
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(World world) {
        if (activeTreekeepingMode != null) {
            return activeTreekeepingMode;
        }
        IArboristTracker tracker = this.getBreedingTracker(world, null);
        String mode = tracker.getModeName();
        if (mode == null || mode.isEmpty()) {
            mode = PluginArboriculture.treekeepingMode;
        }
        this.setTreekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().debug("Set Treekeeping mode for a world to " + mode);
        return activeTreekeepingMode;
    }

    @Override
    public void registerTreekeepingMode(ITreekeepingMode mode) {
        this.treekeepingModes.add(mode);
    }

    @Override
    public void setTreekeepingMode(World world, String name) {
        activeTreekeepingMode = this.getTreekeepingMode(name);
        this.getBreedingTracker(world, null).setModeName(name);
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(String name) {
        for (ITreekeepingMode mode : this.treekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().debug("Failed to find a Treekeeping mode called '%s', reverting to fallback.");
        return this.treekeepingModes.get(0);
    }

    @Override
    public ArrayList<ITree> getIndividualTemplates() {
        return treeTemplates;
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        treeTemplates.add(new Tree(TreeManager.treeRoot.templateAsGenome(template)));
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return TreeDefinition.Oak.getTemplate();
    }

    public List<ITreeMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(treeMutations);
        }
        return treeMutations;
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        treeMutations.add((ITreeMutation)mutation);
    }

    @Override
    public void registerLeafTickHandler(ILeafTickHandler handler) {
        this.leafTickHandlers.add(handler);
    }

    @Override
    public Collection<ILeafTickHandler> getLeafTickHandlers() {
        return this.leafTickHandlers;
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumTreeChromosome.values();
    }

    @Override
    public IChromosomeType getKaryotypeKey() {
        return EnumTreeChromosome.SPECIES;
    }

    static {
        treeTemplates = new ArrayList();
        treeMutations = new ArrayList<ITreeMutation>();
    }
}

