/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.element;

import chylex.hee.api.message.MessageRunner;
import chylex.hee.api.message.element.IntValue;
import chylex.hee.api.message.element.ItemStackValue;
import chylex.hee.api.message.element.base.Optional;
import chylex.hee.api.message.element.base.PreconditionComposite;
import chylex.hee.system.util.ItemDamagePair;
import net.minecraft.item.Item;

public class ItemDamagePairValue
extends PreconditionComposite<ItemDamagePair> {
    public static final ItemDamagePairValue any() {
        return new ItemDamagePairValue();
    }

    private ItemDamagePairValue() {
        this.addCondition("id", ItemStackValue.itemString);
        this.addCondition("damage", Optional.of(IntValue.any(), -1));
    }

    @Override
    public ItemDamagePair getValue(MessageRunner runner) {
        Item item = ItemStackValue.getItemFromString(runner.getString("id"));
        if (item == null) {
            throw new IllegalStateException("Failed constructing an ItemDamagePair from IMC, item is null.");
        }
        int damage = runner.getInt("damage");
        return new ItemDamagePair(item, damage < 0 ? -1 : damage);
    }
}

