/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.tileentity.spawner.BlobEndermanSpawnerLogic;
import chylex.hee.tileentity.spawner.CustomSpawnerLogic;
import chylex.hee.tileentity.spawner.LouseRavagedSpawnerLogic;
import chylex.hee.tileentity.spawner.SilverfishDungeonSpawnerLogic;
import chylex.hee.tileentity.spawner.SilverfishRavagedSpawnerLogic;
import chylex.hee.tileentity.spawner.TowerEndermanSpawnerLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCustomSpawner
extends TileEntity {
    private byte logicId;
    private CustomSpawnerLogic logic;
    private int actualX;
    private int actualY = -1;
    private int actualZ;

    public TileEntityCustomSpawner setLogicId(int id) {
        this.createLogic((byte)id);
        return this;
    }

    private void createLogic(byte id) {
        switch (id) {
            case 0: {
                this.logic = new TowerEndermanSpawnerLogic(this);
                break;
            }
            case 1: {
                this.logic = new SilverfishDungeonSpawnerLogic(this);
                break;
            }
            case 2: {
                this.logic = new LouseRavagedSpawnerLogic(this);
                break;
            }
            case 3: {
                this.logic = new SilverfishRavagedSpawnerLogic(this);
                break;
            }
            case 4: {
                this.logic = new BlobEndermanSpawnerLogic(this);
                break;
            }
            default: {
                Log.error("Unable to find spawner logic $0, this is not supposed to happen! Substituting empty logic to prevent crashes.", id);
                this.logic = new CustomSpawnerLogic.BrokenSpawnerLogic(this);
            }
        }
        this.logicId = id;
    }

    public void func_145845_h() {
        if (this.actualY == -1) {
            this.actualX = this.field_145851_c;
            this.actualY = this.field_145848_d;
            this.actualZ = this.field_145849_e;
        } else if (this.field_145851_c == this.actualX && this.field_145848_d == this.actualY && this.field_145849_e == this.actualZ) {
            this.logic.func_98278_g();
        }
        super.func_145845_h();
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        tag.func_82580_o("SpawnPotentials");
        tag.func_82580_o("actualPos");
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public boolean func_145842_c(int eventNb, int arg) {
        return this.logic.func_98268_b(eventNb) || super.func_145842_c(eventNb, arg);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("logicId", this.logicId);
        nbt.func_74772_a("actualPos", BlockPosM.tmp(this.actualX, this.actualY, this.actualZ).toLong());
        this.logic.func_98280_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.createLogic(nbt.func_74771_c("logicId"));
        BlockPosM actualPos = BlockPosM.fromNBT(nbt, "actualPos");
        this.actualX = actualPos.x;
        this.actualY = actualPos.y;
        this.actualZ = actualPos.z;
        this.logic.func_98270_a(nbt);
    }

    public CustomSpawnerLogic getSpawnerLogic() {
        return this.logic;
    }
}

