/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon;

import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonDir;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElement;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementList;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementType;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;

public final class DungeonLayer {
    private final DungeonElementType[][] elementArray;
    private final DungeonElementList elementList;
    private final TIntHashSet blockedLocs;
    private final byte width;
    private final byte height;
    private byte x = (byte)-128;
    private byte y = (byte)-128;
    private byte entranceX = (byte)-1;
    private byte entranceY = (byte)-1;

    public DungeonLayer(int width, int height, TIntHashSet blockedLocs) {
        this.elementArray = new DungeonElementType[width][height];
        this.elementList = new DungeonElementList(width, height);
        for (int xx = 0; xx < width; ++xx) {
            for (int yy = 0; yy < height; ++yy) {
                this.elementArray[xx][yy] = DungeonElementType.EMPTY;
            }
        }
        this.width = (byte)width;
        this.height = (byte)height;
        this.blockedLocs = blockedLocs;
    }

    public void createEntrance(int x, int y) {
        if (this.entranceX != -1 || this.entranceY != -1) {
            throw new IllegalStateException("Created entrance twice!");
        }
        this.entranceX = this.x = (byte)x;
        this.entranceY = this.y = (byte)y;
        this.elementArray[x][y] = DungeonElementType.ENTRANCE;
        this.elementList.add(new DungeonElement(x, y, DungeonElementType.ENTRANCE));
    }

    public void createDescend(int x, int y) {
        if (this.elementList.getTypeAt(x, y) != DungeonElementType.ROOM) {
            throw new IllegalStateException("Cannot create descend, invalid dungeon element!");
        }
        this.elementArray[x][y] = DungeonElementType.DESCEND;
        DungeonElement descend = new DungeonElement(x, y, DungeonElementType.DESCEND);
        this.elementList.add(descend);
        for (DungeonDir dir : DungeonDir.values) {
            DungeonElement element = this.elementList.getAt(x + dir.addX * 2, y + dir.addY * 2);
            if (element == null) continue;
            descend.connect(dir);
            element.connect(dir.reversed());
        }
    }

    public void createDescendBottom(int x, int y) {
        this.entranceX = this.x = (byte)x;
        this.entranceY = this.y = (byte)y;
        this.elementArray[x][y] = DungeonElementType.DESCENDBOTTOM;
        this.elementList.add(new DungeonElement(x, y, DungeonElementType.DESCENDBOTTOM));
    }

    public void createEnd(int x, int y) {
        if (this.elementList.getTypeAt(x, y) != DungeonElementType.ROOM) {
            throw new IllegalStateException("Cannot create end, invalid dungeon element!");
        }
        Set<DungeonElement> connected = this.elementList.getGrouped(this.elementList.getAt(x, y));
        if (connected.size() != 4) {
            throw new IllegalStateException("Cannot create end, invalid dungeon element size!");
        }
        ArrayList<DungeonElement> endElements = new ArrayList<DungeonElement>();
        for (DungeonElement element : connected) {
            this.elementList.remove(element);
            DungeonElement newElement = new DungeonElement(element.x, element.y, DungeonElementType.END);
            this.elementArray[element.x][element.y] = DungeonElementType.END;
            endElements.add(newElement);
            this.elementList.add(newElement);
            DungeonDir[] dungeonDirArray = DungeonDir.values;
            int n = dungeonDirArray.length;
            for (int i = 0; i < n; ++i) {
                DungeonDir dir = dungeonDirArray[i];
                if (!element.checkConnection(dir)) continue;
                newElement.connect(dir);
            }
        }
        for (DungeonElement endElement : endElements) {
            for (DungeonDir dir : DungeonDir.values) {
                if (this.elementList.getTypeAt(endElement.x + dir.addX * 2, endElement.y + dir.addY * 2) != DungeonElementType.END) continue;
                endElement.connect(dir);
            }
        }
    }

    public boolean addHallway(DungeonDir dir) {
        int amount = this.elementArray[this.x][this.y] == DungeonElementType.ROOM ? 2 : 1;
        byte prevX = this.x;
        byte prevY = this.y;
        if (this.move(dir, amount)) {
            if (this.elementArray[this.x][this.y] == DungeonElementType.EMPTY) {
                this.elementArray[this.x][this.y] = DungeonElementType.HALLWAY;
                this.elementList.add(new DungeonElement(this.x, this.y, DungeonElementType.HALLWAY).connect(dir.reversed()));
                if (this.elementList.getAt(prevX, prevY) != null) {
                    this.elementList.getAt(prevX, prevY).connect(dir);
                }
                return true;
            }
            this.move(dir.reversed(), amount);
        }
        return false;
    }

    public boolean canGenerateRoom(DungeonDir dir) {
        byte tempX = this.x;
        byte tempY = this.y;
        boolean res = false;
        if (this.move(dir, 2) && this.check(this.x - 1, this.y - 1) && this.check(this.x + 1, this.y + 1)) {
            for (int xx = this.x - 1; xx <= this.x + 1; ++xx) {
                for (int yy = this.y - 1; yy <= this.y + 1; ++yy) {
                    if (this.elementArray[xx][yy] == DungeonElementType.EMPTY && !this.blockedLocs.contains(xx + yy * this.width)) continue;
                    this.x = tempX;
                    this.y = tempY;
                    return false;
                }
            }
            res = true;
        }
        this.x = tempX;
        this.y = tempY;
        return res;
    }

    public int addRoom(DungeonDir dir, Random rand) {
        if (!this.canGenerateRoom(dir)) {
            return 0;
        }
        byte prevX = this.x;
        byte prevY = this.y;
        if (this.move(dir, 2)) {
            DungeonElementType.RoomCombo shape;
            this.addRoomAt(this.x, this.y);
            this.elementList.getAt(this.x, this.y).connect(dir.reversed());
            DungeonElement prevElement = this.elementList.getAt(prevX, prevY);
            if (prevElement != null) {
                prevElement.connect(dir);
            }
            if ((shape = DungeonElementType.RoomCombo.random(rand)) != DungeonElementType.RoomCombo.SINGLE) {
                ArrayList<byte[]> rooms = new ArrayList<byte[]>(4);
                byte origX = this.x;
                byte origY = this.y;
                block0 : switch (shape) {
                    case LONG: {
                        switch (rand.nextInt(3)) {
                            case 0: {
                                dir = dir.rotatedLeft();
                                break;
                            }
                            case 1: {
                                dir = dir.rotatedRight();
                                break;
                            }
                        }
                        this.move(dir, 1);
                        if (!this.canGenerateRoom(dir)) break;
                        this.move(dir, 2);
                        rooms.add(new byte[]{this.x, this.y});
                        break;
                    }
                    case TURN: 
                    case BLOCK: {
                        boolean turnWay = rand.nextBoolean();
                        for (int a = 0; a < (shape == DungeonElementType.RoomCombo.TURN ? 2 : 3); ++a) {
                            this.move(dir, 1);
                            if (!this.canGenerateRoom(dir)) {
                                rooms.clear();
                                break block0;
                            }
                            this.move(dir, 2);
                            rooms.add(new byte[]{this.x, this.y});
                            dir = turnWay ? dir.rotatedLeft() : dir.rotatedRight();
                        }
                        break;
                    }
                }
                for (byte[] loc : rooms) {
                    this.addRoomAt(loc[0], loc[1]);
                }
                rooms.add(new byte[]{origX, origY});
                if (rooms.size() > 1) {
                    for (byte[] loc : rooms) {
                        for (DungeonDir testDir : DungeonDir.values) {
                            int xx = loc[0] + testDir.addX * 3;
                            int yy = loc[1] + testDir.addY * 3;
                            if (this.elementList.getTypeAt(xx, yy) != DungeonElementType.ROOM) continue;
                            boolean found = false;
                            for (byte[] testLoc : rooms) {
                                if (testLoc[0] != xx || testLoc[1] != yy) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            this.elementList.getAt(loc[0], loc[1]).connect(testDir);
                        }
                    }
                }
                byte[] moveTo = (byte[])rooms.get(rand.nextInt(rooms.size()));
                this.moveToElement(this.elementList.getAt(moveTo[0], moveTo[1]));
                return rooms.size();
            }
            return 1;
        }
        return 0;
    }

    private void addRoomAt(int x, int y) {
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                this.elementArray[xx][yy] = DungeonElementType.ROOM;
            }
        }
        this.elementList.add(new DungeonElement(x, y, DungeonElementType.ROOM));
    }

    public DungeonElementList getElements() {
        return this.elementList;
    }

    public void moveToEntrance() {
        this.x = this.entranceX;
        this.y = this.entranceY;
    }

    public void moveToElement(DungeonElement element) {
        this.x = element.x;
        this.y = element.y;
    }

    private boolean check(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height && !this.blockedLocs.contains(x + y * this.width);
    }

    private boolean move(DungeonDir dir, int amount) {
        this.x = (byte)(this.x + dir.addX * amount);
        this.y = (byte)(this.y + dir.addY * amount);
        if (this.check(this.x, this.y)) {
            return true;
        }
        this.x = (byte)(this.x - dir.addX * amount);
        this.y = (byte)(this.y - dir.addY * amount);
        return false;
    }
}

