/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.TileCapBank;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class PacketCapBank<T extends PacketCapBank<T, Q>, Q extends IMessage>
implements IMessage,
IMessageHandler<T, Q> {
    private int x;
    private int y;
    private int z;

    public PacketCapBank() {
    }

    public PacketCapBank(TileCapBank capBank) {
        this.x = capBank.field_145851_c;
        this.y = capBank.field_145848_d;
        this.z = capBank.field_145849_e;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public Q onMessage(T message, MessageContext ctx) {
        TileCapBank te = this.getTileEntity(message, ctx);
        if (te == null) {
            return null;
        }
        return this.handleMessage(te, message, ctx);
    }

    protected abstract Q handleMessage(TileCapBank var1, T var2, MessageContext var3);

    protected TileCapBank getTileEntity(T message, MessageContext ctx) {
        World worldObj = this.getWorld(ctx);
        if (worldObj == null) {
            return null;
        }
        TileEntity te = worldObj.func_147438_o(((PacketCapBank)message).getX(), ((PacketCapBank)message).getY(), ((PacketCapBank)message).getZ());
        if (te == null) {
            return null;
        }
        if (te instanceof TileCapBank) {
            return (TileCapBank)te;
        }
        return null;
    }

    protected World getWorld(MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ctx.getServerHandler().field_147369_b.field_70170_p;
        }
        return EnderIO.proxy.getClientWorld();
    }
}

