/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class NEIAltarRecipeHandler
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("alchemicalwizardry.altar") && ((Object)((Object)this)).getClass() == NEIAltarRecipeHandler.class) {
            for (AltarRecipe recipe : AltarRecipeRegistry.altarRecipes) {
                if (recipe == null || recipe.result == null) continue;
                this.arecipes.add(new CachedAltarRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (AltarRecipe recipe : AltarRecipeRegistry.altarRecipes) {
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)recipe.result, (ItemStack)result) || recipe.result == null) continue;
            this.arecipes.add(new CachedAltarRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (AltarRecipe recipe : AltarRecipeRegistry.altarRecipes) {
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)recipe.requiredItem, (ItemStack)ingredient) || recipe.result == null) continue;
            this.arecipes.add(new CachedAltarRecipe(recipe));
        }
    }

    public void drawExtras(int id) {
        CachedAltarRecipe recipe = (CachedAltarRecipe)((Object)this.arecipes.get(id));
        Minecraft.func_71410_x().field_71466_p.func_78276_b(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"bm.string.tier") + ": " + recipe.tier, 78, 5, 0);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(EnumChatFormatting.GRAY + "LP: " + recipe.lp_amount, 78, 15, 0);
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int id) {
        super.handleTooltip(gui, currenttip, id);
        if (this.altarRect(gui, id).contains(GuiDraw.getMousePosition())) {
            CachedAltarRecipe recipe = (CachedAltarRecipe)((Object)this.arecipes.get(id));
            currenttip.add(StatCollector.func_74838_a((String)"bm.string.consume") + ": " + recipe.consumption + "LP/t");
            currenttip.add(StatCollector.func_74838_a((String)"bm.string.drain") + ": " + recipe.drain + "LP/t");
        }
        return currenttip;
    }

    public Rectangle altarRect(GuiRecipe<?> gui, int id) {
        Point root = gui.getRecipePosition(id);
        int offsetX = gui.field_147003_i + root.x;
        int offsetY = gui.field_147009_r + root.y;
        return new Rectangle(14 + offsetX, 22 + offsetY, 62, 34);
    }

    public String getOverlayIdentifier() {
        return "altarrecipes";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(90, 32, 22, 16), "alchemicalwizardry.altar", new Object[0]));
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.bloodAltar.name");
    }

    public String getGuiTexture() {
        return new ResourceLocation("alchemicalwizardry", "gui/nei/altar.png").toString();
    }

    public class CachedAltarRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        int tier;
        int lp_amount;
        int consumption;
        int drain;

        public CachedAltarRecipe(AltarRecipe recipe) {
            super((TemplateRecipeHandler)NEIAltarRecipeHandler.this);
            this.input = new PositionedStack((Object)recipe.requiredItem, 38, 2, false);
            this.output = new PositionedStack((Object)recipe.result, 132, 32, false);
            this.tier = recipe.minTier;
            this.lp_amount = recipe.liquidRequired;
            this.consumption = recipe.consumptionRate;
            this.drain = recipe.drainRate;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

